@component('mail::message')
# 🚨 Your Subscription Has Expired

Dear **{{ $society->name }}** Team,

Your subscription has expired. Your society's access to {{ $appName }} has been limited.

## Expired Subscription

@component('mail::panel')
| | |
|---|---|
| **Plan** | {{ $subscription->plan_display_name ?? $subscription->plan_name }} |
| **Expired On** | {{ $subscription->end_date?->format('d M, Y') }} |
| **Status** | Expired |
@endcomponent

## What's Affected?

- ❌ Residents cannot access the mobile app
- ❌ No new bills can be generated
- ❌ Payments cannot be processed
- ❌ Visitor management is disabled

## Renew Now to Restore Access

Renew your subscription to immediately restore full access for your society.

@component('mail::button', ['url' => $renewUrl, 'color' => 'success'])
Renew Subscription
@endcomponent

If you have any questions about your subscription, please contact our support team.

Thanks,<br>
The {{ $appName }} Team
@endcomponent
