@component('mail::message')
# Subscription Activated! ✅

Dear **{{ $society->name }}** Team,

Great news! Your subscription has been successfully activated.

## Subscription Details

@component('mail::panel')
| | |
|---|---|
| **Plan** | {{ $subscription->plan_display_name ?? $subscription->plan_name }} |
| **Billing Cycle** | {{ ucfirst($subscription->billing_cycle) }} |
| **Start Date** | {{ $subscription->start_date?->format('d M, Y') }} |
| **End Date** | {{ $subscription->end_date?->format('d M, Y') }} |
| **Status** | Active ✓ |
@endcomponent

## Plan Features

Your plan includes:
- Up to **{{ $subscription->max_units }}** units
- Up to **{{ $subscription->max_users }}** users
- Up to **{{ $subscription->max_buildings }}** buildings
@if($subscription->sms_enabled)
- SMS Notifications
@endif
@if($subscription->email_enabled)
- Email Notifications
@endif
@if($subscription->fcm_enabled)
- Push Notifications
@endif
@if($subscription->advanced_reports)
- Advanced Reports
@endif

@component('mail::button', ['url' => $dashboardUrl, 'color' => 'success'])
Go to Dashboard
@endcomponent

Thanks for choosing {{ $appName }}!

Best regards,<br>
The {{ $appName }} Team
@endcomponent
