@component('mail::message')
# Welcome to {{ $appName }}! 🎉

Dear **{{ $admin->name }}**,

Congratulations! Your society **{{ $society->name }}** has been successfully registered on {{ $appName }}.

## Your Login Details

@component('mail::panel')
**Email:** {{ $admin->email }}

@if($plainPassword)
**Password:** {{ $plainPassword }}

> Please change your password after first login for security.
@else
Use the password you set during registration.
@endif
@endcomponent

## Society Details

| | |
|---|---|
| **Society Name** | {{ $society->name }} |
| **Society Code** | {{ $society->code }} |
| **Registration No.** | {{ $society->registration_no }} |
| **Address** | {{ $society->address }}, {{ $society->city }} |

@component('mail::button', ['url' => $loginUrl, 'color' => 'success'])
Login to Dashboard
@endcomponent

## What's Next?

1. **Complete your profile** - Add society logo and details
2. **Add buildings & units** - Set up your property structure
3. **Invite residents** - Let your community join
4. **Set up billing** - Configure maintenance charges

If you have any questions, our support team is here to help!

Thanks,<br>
The {{ $appName }} Team
@endcomponent
