@component('mail::message')
# Payment Received ✅

Dear **{{ $resident->name }}**,

Thank you! We have received your payment.

## Payment Details

@component('mail::panel')
| | |
|---|---|
| **Payment ID** | {{ $payment->payment_no }} |
| **Amount** | ₹{{ number_format($payment->amount, 2) }} |
| **Method** | {{ ucfirst($payment->payment_method) }} |
| **Date** | {{ $payment->created_at->format('d M, Y H:i') }} |
| **Status** | Completed ✓ |
@endcomponent

## Bill Information

| | |
|---|---|
| **Bill No.** | {{ $bill->bill_no }} |
| **Bill Amount** | ₹{{ number_format($bill->amount, 2) }} |
| **Bill Status** | {{ ucfirst($bill->status) }} |

This email serves as your payment receipt.

Thanks,<br>
{{ $society->name }}
@endcomponent
