@component('mail::message')
# 🚨 Bill Overdue

Dear **{{ $resident->name }}**,

Your maintenance bill is **{{ $daysOverdue }} {{ $daysOverdue === 1 ? 'day' : 'days' }} overdue**.

## Overdue Bill Details

@component('mail::panel')
| | |
|---|---|
| **Bill No.** | {{ $bill->bill_no }} |
| **Amount** | ₹{{ number_format($bill->amount, 2) }} |
| **Due Date** | {{ $bill->due_date->format('d M, Y') }} |
| **Days Overdue** | {{ $daysOverdue }} |
@endcomponent

> [!CAUTION]
> Late fees may apply. Please pay immediately to avoid additional charges.

@component('mail::button', ['url' => $appUrl, 'color' => 'success'])
Pay Now
@endcomponent

If you have already made the payment, please disregard this email.

Thanks,<br>
{{ $society->name }}
@endcomponent
