@component('mail::message')
# New Bill Generated

Dear **{{ $resident->name }}**,

A new maintenance bill has been generated for your unit at **{{ $society->name }}**.

## Bill Details

@component('mail::panel')
| | |
|---|---|
| **Bill No.** | {{ $bill->bill_no }} |
| **Amount** | ₹{{ number_format($bill->amount, 2) }} |
| **Due Date** | {{ $bill->due_date->format('d M, Y') }} |
| **Status** | {{ ucfirst($bill->status) }} |
@endcomponent

@if($bill->description)
**Description:** {{ $bill->description }}
@endif

Please pay before the due date to avoid late fees.

@component('mail::button', ['url' => $appUrl, 'color' => 'success'])
Pay Now
@endcomponent

Thanks,<br>
{{ $society->name }}
@endcomponent
