@component('mail::message')
# Bill Payment Reminder

Dear **{{ $resident->name }}**,

@if($daysUntilDue === 0)
Your maintenance bill is **due today**!
@else
Your maintenance bill is due in **{{ $daysUntilDue }} {{ $daysUntilDue === 1 ? 'day' : 'days' }}**.
@endif

## Bill Details

@component('mail::panel')
| | |
|---|---|
| **Bill No.** | {{ $bill->bill_no }} |
| **Amount** | ₹{{ number_format($bill->amount, 2) }} |
| **Due Date** | {{ $bill->due_date->format('d M, Y') }} |
@endcomponent

Please pay before the due date to avoid late fees and service interruption.

@component('mail::button', ['url' => $appUrl, 'color' => 'primary'])
Pay Now
@endcomponent

Thanks,<br>
{{ $society->name }}
@endcomponent
