export interface Facility {
    id: number;
    society_id: number;
    name: string;
    description: string | null;
    images: string[] | null;
    capacity: number | null;
    amenities: string | null;
    rules: string | null;
    cancellation_policy: string | null;
    is_active: boolean;
    requires_approval: boolean;
    created_at: string;
    updated_at: string;
    slots?: FacilitySlot[];
    bookings?: FacilityBooking[];
    bookings_count?: number;
}

export interface FacilitySlot {
    id: number;
    facility_id: number;
    name: string;
    start_time: string;
    end_time: string;
    price: string | number;
    max_bookings_per_slot: number;
    is_active: boolean;
    created_at: string;
    updated_at: string;
    time_range?: string;
    facility?: Facility;
}

export interface FacilityBooking {
    id: number;
    society_id: number;
    facility_id: number;
    slot_id: number;
    user_id: number;
    booked_by: number | null;
    booking_date: string;
    amount: string | number;
    payment_status: 'pending' | 'paid' | 'failed' | 'refunded';
    payment_method: string | null;
    booking_status: 'pending' | 'confirmed' | 'cancelled' | 'rejected' | 'completed';
    purpose: string | null;
    guest_count: number | null;
    admin_notes: string | null;
    cancellation_reason: string | null;
    checked_in_at: string | null;
    checked_out_at: string | null;
    payment_details: any | null;
    created_at: string;
    updated_at: string;
    facility?: Facility;
    slot?: FacilitySlot;
    user?: {
        id: number;
        name: string;
        email: string;
        phone: string;
        unit?: {
            id: number;
            unit_no: string;
            building: {
                id: number;
                name: string;
            };
        };
    };
    bookedBy?: {
        id: number;
        name: string;
        role: {
            name: string;
        };
    };
    status_color?: string;
    payment_status_color?: string;
}

export interface FacilityStats {
    total_bookings: number;
    pending_approval: number;
    confirmed: number;
    revenue_collected: string | number;
    revenue_pending: string | number;
}
