import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::index
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:19
* @route '/super-admin/subscription-plans'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/super-admin/subscription-plans',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::index
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:19
* @route '/super-admin/subscription-plans'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::index
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:19
* @route '/super-admin/subscription-plans'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::index
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:19
* @route '/super-admin/subscription-plans'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::index
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:19
* @route '/super-admin/subscription-plans'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::index
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:19
* @route '/super-admin/subscription-plans'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::index
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:19
* @route '/super-admin/subscription-plans'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::create
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:50
* @route '/super-admin/subscription-plans/create'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/super-admin/subscription-plans/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::create
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:50
* @route '/super-admin/subscription-plans/create'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::create
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:50
* @route '/super-admin/subscription-plans/create'
*/
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::create
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:50
* @route '/super-admin/subscription-plans/create'
*/
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::create
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:50
* @route '/super-admin/subscription-plans/create'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::create
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:50
* @route '/super-admin/subscription-plans/create'
*/
createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::create
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:50
* @route '/super-admin/subscription-plans/create'
*/
createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::store
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:58
* @route '/super-admin/subscription-plans'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/super-admin/subscription-plans',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::store
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:58
* @route '/super-admin/subscription-plans'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::store
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:58
* @route '/super-admin/subscription-plans'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::store
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:58
* @route '/super-admin/subscription-plans'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::store
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:58
* @route '/super-admin/subscription-plans'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::show
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:69
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
export const show = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/super-admin/subscription-plans/{subscription_plan}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::show
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:69
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
show.url = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { subscription_plan: args }
    }

    if (Array.isArray(args)) {
        args = {
            subscription_plan: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        subscription_plan: args.subscription_plan,
    }

    return show.definition.url
            .replace('{subscription_plan}', parsedArgs.subscription_plan.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::show
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:69
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
show.get = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::show
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:69
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
show.head = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::show
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:69
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
const showForm = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::show
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:69
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
showForm.get = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::show
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:69
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
showForm.head = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::edit
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:81
* @route '/super-admin/subscription-plans/{subscription_plan}/edit'
*/
export const edit = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/super-admin/subscription-plans/{subscription_plan}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::edit
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:81
* @route '/super-admin/subscription-plans/{subscription_plan}/edit'
*/
edit.url = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { subscription_plan: args }
    }

    if (Array.isArray(args)) {
        args = {
            subscription_plan: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        subscription_plan: args.subscription_plan,
    }

    return edit.definition.url
            .replace('{subscription_plan}', parsedArgs.subscription_plan.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::edit
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:81
* @route '/super-admin/subscription-plans/{subscription_plan}/edit'
*/
edit.get = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::edit
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:81
* @route '/super-admin/subscription-plans/{subscription_plan}/edit'
*/
edit.head = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::edit
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:81
* @route '/super-admin/subscription-plans/{subscription_plan}/edit'
*/
const editForm = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::edit
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:81
* @route '/super-admin/subscription-plans/{subscription_plan}/edit'
*/
editForm.get = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::edit
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:81
* @route '/super-admin/subscription-plans/{subscription_plan}/edit'
*/
editForm.head = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::update
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:91
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
export const update = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/super-admin/subscription-plans/{subscription_plan}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::update
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:91
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
update.url = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { subscription_plan: args }
    }

    if (Array.isArray(args)) {
        args = {
            subscription_plan: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        subscription_plan: args.subscription_plan,
    }

    return update.definition.url
            .replace('{subscription_plan}', parsedArgs.subscription_plan.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::update
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:91
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
update.put = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::update
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:91
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
update.patch = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::update
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:91
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
const updateForm = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::update
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:91
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
updateForm.put = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::update
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:91
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
updateForm.patch = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::destroy
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:102
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
export const destroy = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/super-admin/subscription-plans/{subscription_plan}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::destroy
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:102
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
destroy.url = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { subscription_plan: args }
    }

    if (Array.isArray(args)) {
        args = {
            subscription_plan: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        subscription_plan: args.subscription_plan,
    }

    return destroy.definition.url
            .replace('{subscription_plan}', parsedArgs.subscription_plan.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::destroy
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:102
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
destroy.delete = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::destroy
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:102
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
const destroyForm = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SubscriptionPlanController::destroy
* @see app/Http/Controllers/SuperAdmin/SubscriptionPlanController.php:102
* @route '/super-admin/subscription-plans/{subscription_plan}'
*/
destroyForm.delete = (args: { subscription_plan: string | number } | [subscription_plan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const subscriptionPlans = {
    index: Object.assign(index, index),
    create: Object.assign(create, create),
    store: Object.assign(store, store),
    show: Object.assign(show, show),
    edit: Object.assign(edit, edit),
    update: Object.assign(update, update),
    destroy: Object.assign(destroy, destroy),
}

export default subscriptionPlans