import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::upload
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:148
* @route '/super-admin/settings/firebase/upload'
*/
export const upload = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: upload.url(options),
    method: 'post',
})

upload.definition = {
    methods: ["post"],
    url: '/super-admin/settings/firebase/upload',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::upload
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:148
* @route '/super-admin/settings/firebase/upload'
*/
upload.url = (options?: RouteQueryOptions) => {
    return upload.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::upload
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:148
* @route '/super-admin/settings/firebase/upload'
*/
upload.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: upload.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::upload
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:148
* @route '/super-admin/settings/firebase/upload'
*/
const uploadForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: upload.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::upload
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:148
* @route '/super-admin/settings/firebase/upload'
*/
uploadForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: upload.url(options),
    method: 'post',
})

upload.form = uploadForm

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::remove
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:211
* @route '/super-admin/settings/firebase/remove'
*/
export const remove = (options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: remove.url(options),
    method: 'delete',
})

remove.definition = {
    methods: ["delete"],
    url: '/super-admin/settings/firebase/remove',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::remove
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:211
* @route '/super-admin/settings/firebase/remove'
*/
remove.url = (options?: RouteQueryOptions) => {
    return remove.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::remove
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:211
* @route '/super-admin/settings/firebase/remove'
*/
remove.delete = (options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: remove.url(options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::remove
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:211
* @route '/super-admin/settings/firebase/remove'
*/
const removeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: remove.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::remove
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:211
* @route '/super-admin/settings/firebase/remove'
*/
removeForm.delete = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: remove.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

remove.form = removeForm

const firebase = {
    upload: Object.assign(upload, upload),
    remove: Object.assign(remove, remove),
}

export default firebase