import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../wayfinder'
import societies from './societies'
import users from './users'
import subscriptionPlans from './subscription-plans'
import settings from './settings'
import cms from './cms'
/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::login
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:18
* @route '/super-admin/login'
*/
export const login = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: login.url(options),
    method: 'get',
})

login.definition = {
    methods: ["get","head"],
    url: '/super-admin/login',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::login
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:18
* @route '/super-admin/login'
*/
login.url = (options?: RouteQueryOptions) => {
    return login.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::login
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:18
* @route '/super-admin/login'
*/
login.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: login.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::login
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:18
* @route '/super-admin/login'
*/
login.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: login.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::login
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:18
* @route '/super-admin/login'
*/
const loginForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: login.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::login
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:18
* @route '/super-admin/login'
*/
loginForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: login.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::login
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:18
* @route '/super-admin/login'
*/
loginForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: login.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

login.form = loginForm

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::logout
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:50
* @route '/super-admin/logout'
*/
export const logout = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: logout.url(options),
    method: 'post',
})

logout.definition = {
    methods: ["post"],
    url: '/super-admin/logout',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::logout
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:50
* @route '/super-admin/logout'
*/
logout.url = (options?: RouteQueryOptions) => {
    return logout.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::logout
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:50
* @route '/super-admin/logout'
*/
logout.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: logout.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::logout
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:50
* @route '/super-admin/logout'
*/
const logoutForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: logout.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::logout
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:50
* @route '/super-admin/logout'
*/
logoutForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: logout.url(options),
    method: 'post',
})

logout.form = logoutForm

/**
* @see \App\Http\Controllers\SuperAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SuperAdmin/DashboardController.php:15
* @route '/super-admin/dashboard'
*/
export const dashboard = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: dashboard.url(options),
    method: 'get',
})

dashboard.definition = {
    methods: ["get","head"],
    url: '/super-admin/dashboard',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SuperAdmin/DashboardController.php:15
* @route '/super-admin/dashboard'
*/
dashboard.url = (options?: RouteQueryOptions) => {
    return dashboard.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SuperAdmin/DashboardController.php:15
* @route '/super-admin/dashboard'
*/
dashboard.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: dashboard.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SuperAdmin/DashboardController.php:15
* @route '/super-admin/dashboard'
*/
dashboard.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: dashboard.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SuperAdmin/DashboardController.php:15
* @route '/super-admin/dashboard'
*/
const dashboardForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dashboard.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SuperAdmin/DashboardController.php:15
* @route '/super-admin/dashboard'
*/
dashboardForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dashboard.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SuperAdmin/DashboardController.php:15
* @route '/super-admin/dashboard'
*/
dashboardForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dashboard.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

dashboard.form = dashboardForm

const superAdmin = {
    login: Object.assign(login, login),
    logout: Object.assign(logout, logout),
    dashboard: Object.assign(dashboard, dashboard),
    societies: Object.assign(societies, societies),
    users: Object.assign(users, users),
    subscriptionPlans: Object.assign(subscriptionPlans, subscriptionPlans),
    settings: Object.assign(settings, settings),
    cms: Object.assign(cms, cms),
}

export default superAdmin