import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::index
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:10
* @route '/super-admin/cms/features'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/super-admin/cms/features',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::index
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:10
* @route '/super-admin/cms/features'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::index
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:10
* @route '/super-admin/cms/features'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::index
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:10
* @route '/super-admin/cms/features'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::index
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:10
* @route '/super-admin/cms/features'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::index
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:10
* @route '/super-admin/cms/features'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::index
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:10
* @route '/super-admin/cms/features'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::create
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:17
* @route '/super-admin/cms/features/create'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/super-admin/cms/features/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::create
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:17
* @route '/super-admin/cms/features/create'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::create
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:17
* @route '/super-admin/cms/features/create'
*/
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::create
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:17
* @route '/super-admin/cms/features/create'
*/
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::create
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:17
* @route '/super-admin/cms/features/create'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::create
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:17
* @route '/super-admin/cms/features/create'
*/
createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::create
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:17
* @route '/super-admin/cms/features/create'
*/
createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::store
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:22
* @route '/super-admin/cms/features'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/super-admin/cms/features',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::store
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:22
* @route '/super-admin/cms/features'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::store
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:22
* @route '/super-admin/cms/features'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::store
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:22
* @route '/super-admin/cms/features'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::store
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:22
* @route '/super-admin/cms/features'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::show
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:0
* @route '/super-admin/cms/features/{feature}'
*/
export const show = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/super-admin/cms/features/{feature}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::show
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:0
* @route '/super-admin/cms/features/{feature}'
*/
show.url = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { feature: args }
    }

    if (Array.isArray(args)) {
        args = {
            feature: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        feature: args.feature,
    }

    return show.definition.url
            .replace('{feature}', parsedArgs.feature.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::show
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:0
* @route '/super-admin/cms/features/{feature}'
*/
show.get = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::show
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:0
* @route '/super-admin/cms/features/{feature}'
*/
show.head = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::show
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:0
* @route '/super-admin/cms/features/{feature}'
*/
const showForm = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::show
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:0
* @route '/super-admin/cms/features/{feature}'
*/
showForm.get = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::show
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:0
* @route '/super-admin/cms/features/{feature}'
*/
showForm.head = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::edit
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:38
* @route '/super-admin/cms/features/{feature}/edit'
*/
export const edit = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/super-admin/cms/features/{feature}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::edit
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:38
* @route '/super-admin/cms/features/{feature}/edit'
*/
edit.url = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { feature: args }
    }

    if (Array.isArray(args)) {
        args = {
            feature: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        feature: args.feature,
    }

    return edit.definition.url
            .replace('{feature}', parsedArgs.feature.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::edit
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:38
* @route '/super-admin/cms/features/{feature}/edit'
*/
edit.get = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::edit
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:38
* @route '/super-admin/cms/features/{feature}/edit'
*/
edit.head = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::edit
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:38
* @route '/super-admin/cms/features/{feature}/edit'
*/
const editForm = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::edit
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:38
* @route '/super-admin/cms/features/{feature}/edit'
*/
editForm.get = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::edit
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:38
* @route '/super-admin/cms/features/{feature}/edit'
*/
editForm.head = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::update
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:46
* @route '/super-admin/cms/features/{feature}'
*/
export const update = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/super-admin/cms/features/{feature}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::update
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:46
* @route '/super-admin/cms/features/{feature}'
*/
update.url = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { feature: args }
    }

    if (Array.isArray(args)) {
        args = {
            feature: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        feature: args.feature,
    }

    return update.definition.url
            .replace('{feature}', parsedArgs.feature.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::update
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:46
* @route '/super-admin/cms/features/{feature}'
*/
update.put = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::update
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:46
* @route '/super-admin/cms/features/{feature}'
*/
update.patch = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::update
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:46
* @route '/super-admin/cms/features/{feature}'
*/
const updateForm = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::update
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:46
* @route '/super-admin/cms/features/{feature}'
*/
updateForm.put = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::update
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:46
* @route '/super-admin/cms/features/{feature}'
*/
updateForm.patch = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::destroy
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:64
* @route '/super-admin/cms/features/{feature}'
*/
export const destroy = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/super-admin/cms/features/{feature}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::destroy
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:64
* @route '/super-admin/cms/features/{feature}'
*/
destroy.url = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { feature: args }
    }

    if (Array.isArray(args)) {
        args = {
            feature: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        feature: args.feature,
    }

    return destroy.definition.url
            .replace('{feature}', parsedArgs.feature.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::destroy
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:64
* @route '/super-admin/cms/features/{feature}'
*/
destroy.delete = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::destroy
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:64
* @route '/super-admin/cms/features/{feature}'
*/
const destroyForm = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFeatureController::destroy
* @see app/Http/Controllers/SuperAdmin/CmsFeatureController.php:64
* @route '/super-admin/cms/features/{feature}'
*/
destroyForm.delete = (args: { feature: string | number } | [feature: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const features = {
    index: Object.assign(index, index),
    create: Object.assign(create, create),
    store: Object.assign(store, store),
    show: Object.assign(show, show),
    edit: Object.assign(edit, edit),
    update: Object.assign(update, update),
    destroy: Object.assign(destroy, destroy),
}

export default features