import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../wayfinder'
/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/subscription/create-payment-order'
*/
export const createPaymentOrder = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: createPaymentOrder.url(options),
    method: 'post',
})

createPaymentOrder.definition = {
    methods: ["post"],
    url: '/subscription/create-payment-order',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/subscription/create-payment-order'
*/
createPaymentOrder.url = (options?: RouteQueryOptions) => {
    return createPaymentOrder.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/subscription/create-payment-order'
*/
createPaymentOrder.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: createPaymentOrder.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/subscription/create-payment-order'
*/
const createPaymentOrderForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: createPaymentOrder.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/subscription/create-payment-order'
*/
createPaymentOrderForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: createPaymentOrder.url(options),
    method: 'post',
})

createPaymentOrder.form = createPaymentOrderForm

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/subscription/verify-payment'
*/
export const verifyPayment = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: verifyPayment.url(options),
    method: 'post',
})

verifyPayment.definition = {
    methods: ["post"],
    url: '/subscription/verify-payment',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/subscription/verify-payment'
*/
verifyPayment.url = (options?: RouteQueryOptions) => {
    return verifyPayment.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/subscription/verify-payment'
*/
verifyPayment.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: verifyPayment.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/subscription/verify-payment'
*/
const verifyPaymentForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: verifyPayment.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/subscription/verify-payment'
*/
verifyPaymentForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: verifyPayment.url(options),
    method: 'post',
})

verifyPayment.form = verifyPaymentForm

/**
* @see routes/web.php:132
* @route '/subscription/renew'
*/
export const renew = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: renew.url(options),
    method: 'get',
})

renew.definition = {
    methods: ["get","head"],
    url: '/subscription/renew',
} satisfies RouteDefinition<["get","head"]>

/**
* @see routes/web.php:132
* @route '/subscription/renew'
*/
renew.url = (options?: RouteQueryOptions) => {
    return renew.definition.url + queryParams(options)
}

/**
* @see routes/web.php:132
* @route '/subscription/renew'
*/
renew.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: renew.url(options),
    method: 'get',
})

/**
* @see routes/web.php:132
* @route '/subscription/renew'
*/
renew.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: renew.url(options),
    method: 'head',
})

/**
* @see routes/web.php:132
* @route '/subscription/renew'
*/
const renewForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: renew.url(options),
    method: 'get',
})

/**
* @see routes/web.php:132
* @route '/subscription/renew'
*/
renewForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: renew.url(options),
    method: 'get',
})

/**
* @see routes/web.php:132
* @route '/subscription/renew'
*/
renewForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: renew.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

renew.form = renewForm

const subscription = {
    createPaymentOrder: Object.assign(createPaymentOrder, createPaymentOrder),
    verifyPayment: Object.assign(verifyPayment, verifyPayment),
    renew: Object.assign(renew, renew),
}

export default subscription