import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../wayfinder'
/**
* @see \App\Http\Controllers\SubAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SubAdmin/DashboardController.php:17
* @route '/societies/{society}/sub-admin/dashboard'
*/
export const dashboard = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: dashboard.url(args, options),
    method: 'get',
})

dashboard.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/sub-admin/dashboard',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SubAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SubAdmin/DashboardController.php:17
* @route '/societies/{society}/sub-admin/dashboard'
*/
dashboard.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return dashboard.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SubAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SubAdmin/DashboardController.php:17
* @route '/societies/{society}/sub-admin/dashboard'
*/
dashboard.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: dashboard.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SubAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SubAdmin/DashboardController.php:17
* @route '/societies/{society}/sub-admin/dashboard'
*/
dashboard.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: dashboard.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SubAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SubAdmin/DashboardController.php:17
* @route '/societies/{society}/sub-admin/dashboard'
*/
const dashboardForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dashboard.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SubAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SubAdmin/DashboardController.php:17
* @route '/societies/{society}/sub-admin/dashboard'
*/
dashboardForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dashboard.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SubAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SubAdmin/DashboardController.php:17
* @route '/societies/{society}/sub-admin/dashboard'
*/
dashboardForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dashboard.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

dashboard.form = dashboardForm

const subAdmin = {
    dashboard: Object.assign(dashboard, dashboard),
}

export default subAdmin