import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::index
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:23
* @route '/societies/{society}/visitors'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/visitors',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::index
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:23
* @route '/societies/{society}/visitors'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::index
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:23
* @route '/societies/{society}/visitors'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::index
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:23
* @route '/societies/{society}/visitors'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::index
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:23
* @route '/societies/{society}/visitors'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::index
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:23
* @route '/societies/{society}/visitors'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::index
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:23
* @route '/societies/{society}/visitors'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::create
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:101
* @route '/societies/{society}/visitors/create'
*/
export const create = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/visitors/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::create
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:101
* @route '/societies/{society}/visitors/create'
*/
create.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return create.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::create
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:101
* @route '/societies/{society}/visitors/create'
*/
create.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::create
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:101
* @route '/societies/{society}/visitors/create'
*/
create.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::create
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:101
* @route '/societies/{society}/visitors/create'
*/
const createForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::create
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:101
* @route '/societies/{society}/visitors/create'
*/
createForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::create
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:101
* @route '/societies/{society}/visitors/create'
*/
createForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::store
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:134
* @route '/societies/{society}/visitors'
*/
export const store = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/societies/{society}/visitors',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::store
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:134
* @route '/societies/{society}/visitors'
*/
store.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return store.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::store
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:134
* @route '/societies/{society}/visitors'
*/
store.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::store
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:134
* @route '/societies/{society}/visitors'
*/
const storeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::store
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:134
* @route '/societies/{society}/visitors'
*/
storeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::show
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:178
* @route '/societies/{society}/visitors/{visitor}'
*/
export const show = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/visitors/{visitor}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::show
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:178
* @route '/societies/{society}/visitors/{visitor}'
*/
show.url = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            visitor: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        visitor: typeof args.visitor === 'object'
        ? args.visitor.id
        : args.visitor,
    }

    return show.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{visitor}', parsedArgs.visitor.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::show
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:178
* @route '/societies/{society}/visitors/{visitor}'
*/
show.get = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::show
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:178
* @route '/societies/{society}/visitors/{visitor}'
*/
show.head = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::show
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:178
* @route '/societies/{society}/visitors/{visitor}'
*/
const showForm = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::show
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:178
* @route '/societies/{society}/visitors/{visitor}'
*/
showForm.get = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::show
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:178
* @route '/societies/{society}/visitors/{visitor}'
*/
showForm.head = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::checkIn
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:208
* @route '/societies/{society}/visitors/{visitor}/check-in'
*/
export const checkIn = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: checkIn.url(args, options),
    method: 'post',
})

checkIn.definition = {
    methods: ["post"],
    url: '/societies/{society}/visitors/{visitor}/check-in',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::checkIn
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:208
* @route '/societies/{society}/visitors/{visitor}/check-in'
*/
checkIn.url = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            visitor: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        visitor: typeof args.visitor === 'object'
        ? args.visitor.id
        : args.visitor,
    }

    return checkIn.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{visitor}', parsedArgs.visitor.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::checkIn
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:208
* @route '/societies/{society}/visitors/{visitor}/check-in'
*/
checkIn.post = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: checkIn.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::checkIn
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:208
* @route '/societies/{society}/visitors/{visitor}/check-in'
*/
const checkInForm = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: checkIn.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::checkIn
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:208
* @route '/societies/{society}/visitors/{visitor}/check-in'
*/
checkInForm.post = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: checkIn.url(args, options),
    method: 'post',
})

checkIn.form = checkInForm

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::checkOut
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:244
* @route '/societies/{society}/visitors/{visitor}/check-out'
*/
export const checkOut = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: checkOut.url(args, options),
    method: 'post',
})

checkOut.definition = {
    methods: ["post"],
    url: '/societies/{society}/visitors/{visitor}/check-out',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::checkOut
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:244
* @route '/societies/{society}/visitors/{visitor}/check-out'
*/
checkOut.url = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            visitor: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        visitor: typeof args.visitor === 'object'
        ? args.visitor.id
        : args.visitor,
    }

    return checkOut.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{visitor}', parsedArgs.visitor.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::checkOut
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:244
* @route '/societies/{society}/visitors/{visitor}/check-out'
*/
checkOut.post = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: checkOut.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::checkOut
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:244
* @route '/societies/{society}/visitors/{visitor}/check-out'
*/
const checkOutForm = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: checkOut.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::checkOut
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:244
* @route '/societies/{society}/visitors/{visitor}/check-out'
*/
checkOutForm.post = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: checkOut.url(args, options),
    method: 'post',
})

checkOut.form = checkOutForm

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::approve
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:274
* @route '/societies/{society}/visitors/{visitor}/approve'
*/
export const approve = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: approve.url(args, options),
    method: 'post',
})

approve.definition = {
    methods: ["post"],
    url: '/societies/{society}/visitors/{visitor}/approve',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::approve
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:274
* @route '/societies/{society}/visitors/{visitor}/approve'
*/
approve.url = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            visitor: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        visitor: typeof args.visitor === 'object'
        ? args.visitor.id
        : args.visitor,
    }

    return approve.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{visitor}', parsedArgs.visitor.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::approve
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:274
* @route '/societies/{society}/visitors/{visitor}/approve'
*/
approve.post = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: approve.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::approve
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:274
* @route '/societies/{society}/visitors/{visitor}/approve'
*/
const approveForm = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: approve.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::approve
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:274
* @route '/societies/{society}/visitors/{visitor}/approve'
*/
approveForm.post = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: approve.url(args, options),
    method: 'post',
})

approve.form = approveForm

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::reject
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:303
* @route '/societies/{society}/visitors/{visitor}/reject'
*/
export const reject = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: reject.url(args, options),
    method: 'post',
})

reject.definition = {
    methods: ["post"],
    url: '/societies/{society}/visitors/{visitor}/reject',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::reject
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:303
* @route '/societies/{society}/visitors/{visitor}/reject'
*/
reject.url = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            visitor: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        visitor: typeof args.visitor === 'object'
        ? args.visitor.id
        : args.visitor,
    }

    return reject.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{visitor}', parsedArgs.visitor.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::reject
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:303
* @route '/societies/{society}/visitors/{visitor}/reject'
*/
reject.post = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: reject.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::reject
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:303
* @route '/societies/{society}/visitors/{visitor}/reject'
*/
const rejectForm = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: reject.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\VisitorController::reject
* @see app/Http/Controllers/SocietyAdmin/VisitorController.php:303
* @route '/societies/{society}/visitors/{visitor}/reject'
*/
rejectForm.post = (args: { society: number | { id: number }, visitor: number | { id: number } } | [society: number | { id: number }, visitor: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: reject.url(args, options),
    method: 'post',
})

reject.form = rejectForm

const visitors = {
    index: Object.assign(index, index),
    create: Object.assign(create, create),
    store: Object.assign(store, store),
    show: Object.assign(show, show),
    checkIn: Object.assign(checkIn, checkIn),
    checkOut: Object.assign(checkOut, checkOut),
    approve: Object.assign(approve, approve),
    reject: Object.assign(reject, reject),
}

export default visitors