import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::index
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:23
* @route '/societies/{society}/units'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/units',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::index
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:23
* @route '/societies/{society}/units'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::index
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:23
* @route '/societies/{society}/units'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::index
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:23
* @route '/societies/{society}/units'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::index
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:23
* @route '/societies/{society}/units'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::index
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:23
* @route '/societies/{society}/units'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::index
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:23
* @route '/societies/{society}/units'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::create
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:93
* @route '/societies/{society}/units/create'
*/
export const create = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/units/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::create
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:93
* @route '/societies/{society}/units/create'
*/
create.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return create.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::create
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:93
* @route '/societies/{society}/units/create'
*/
create.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::create
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:93
* @route '/societies/{society}/units/create'
*/
create.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::create
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:93
* @route '/societies/{society}/units/create'
*/
const createForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::create
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:93
* @route '/societies/{society}/units/create'
*/
createForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::create
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:93
* @route '/societies/{society}/units/create'
*/
createForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::store
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:114
* @route '/societies/{society}/units'
*/
export const store = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/societies/{society}/units',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::store
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:114
* @route '/societies/{society}/units'
*/
store.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return store.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::store
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:114
* @route '/societies/{society}/units'
*/
store.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::store
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:114
* @route '/societies/{society}/units'
*/
const storeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::store
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:114
* @route '/societies/{society}/units'
*/
storeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::show
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:143
* @route '/societies/{society}/units/{unit}'
*/
export const show = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/units/{unit}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::show
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:143
* @route '/societies/{society}/units/{unit}'
*/
show.url = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            unit: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        unit: typeof args.unit === 'object'
        ? args.unit.id
        : args.unit,
    }

    return show.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{unit}', parsedArgs.unit.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::show
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:143
* @route '/societies/{society}/units/{unit}'
*/
show.get = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::show
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:143
* @route '/societies/{society}/units/{unit}'
*/
show.head = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::show
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:143
* @route '/societies/{society}/units/{unit}'
*/
const showForm = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::show
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:143
* @route '/societies/{society}/units/{unit}'
*/
showForm.get = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::show
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:143
* @route '/societies/{society}/units/{unit}'
*/
showForm.head = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::edit
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:167
* @route '/societies/{society}/units/{unit}/edit'
*/
export const edit = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/units/{unit}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::edit
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:167
* @route '/societies/{society}/units/{unit}/edit'
*/
edit.url = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            unit: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        unit: typeof args.unit === 'object'
        ? args.unit.id
        : args.unit,
    }

    return edit.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{unit}', parsedArgs.unit.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::edit
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:167
* @route '/societies/{society}/units/{unit}/edit'
*/
edit.get = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::edit
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:167
* @route '/societies/{society}/units/{unit}/edit'
*/
edit.head = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::edit
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:167
* @route '/societies/{society}/units/{unit}/edit'
*/
const editForm = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::edit
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:167
* @route '/societies/{society}/units/{unit}/edit'
*/
editForm.get = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::edit
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:167
* @route '/societies/{society}/units/{unit}/edit'
*/
editForm.head = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::update
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:199
* @route '/societies/{society}/units/{unit}'
*/
export const update = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/societies/{society}/units/{unit}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::update
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:199
* @route '/societies/{society}/units/{unit}'
*/
update.url = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            unit: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        unit: typeof args.unit === 'object'
        ? args.unit.id
        : args.unit,
    }

    return update.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{unit}', parsedArgs.unit.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::update
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:199
* @route '/societies/{society}/units/{unit}'
*/
update.put = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::update
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:199
* @route '/societies/{society}/units/{unit}'
*/
update.patch = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::update
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:199
* @route '/societies/{society}/units/{unit}'
*/
const updateForm = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::update
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:199
* @route '/societies/{society}/units/{unit}'
*/
updateForm.put = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::update
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:199
* @route '/societies/{society}/units/{unit}'
*/
updateForm.patch = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::destroy
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:236
* @route '/societies/{society}/units/{unit}'
*/
export const destroy = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/societies/{society}/units/{unit}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::destroy
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:236
* @route '/societies/{society}/units/{unit}'
*/
destroy.url = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            unit: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        unit: typeof args.unit === 'object'
        ? args.unit.id
        : args.unit,
    }

    return destroy.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{unit}', parsedArgs.unit.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::destroy
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:236
* @route '/societies/{society}/units/{unit}'
*/
destroy.delete = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::destroy
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:236
* @route '/societies/{society}/units/{unit}'
*/
const destroyForm = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\UnitController::destroy
* @see app/Http/Controllers/SocietyAdmin/UnitController.php:236
* @route '/societies/{society}/units/{unit}'
*/
destroyForm.delete = (args: { society: number | { id: number }, unit: number | { id: number } } | [society: number | { id: number }, unit: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const units = {
    index: Object.assign(index, index),
    create: Object.assign(create, create),
    store: Object.assign(store, store),
    show: Object.assign(show, show),
    edit: Object.assign(edit, edit),
    update: Object.assign(update, update),
    destroy: Object.assign(destroy, destroy),
}

export default units