import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\SettingsController::index
* @see app/Http/Controllers/SocietyAdmin/SettingsController.php:19
* @route '/societies/{society}/settings'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/settings',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\SettingsController::index
* @see app/Http/Controllers/SocietyAdmin/SettingsController.php:19
* @route '/societies/{society}/settings'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\SettingsController::index
* @see app/Http/Controllers/SocietyAdmin/SettingsController.php:19
* @route '/societies/{society}/settings'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\SettingsController::index
* @see app/Http/Controllers/SocietyAdmin/SettingsController.php:19
* @route '/societies/{society}/settings'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\SettingsController::index
* @see app/Http/Controllers/SocietyAdmin/SettingsController.php:19
* @route '/societies/{society}/settings'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\SettingsController::index
* @see app/Http/Controllers/SocietyAdmin/SettingsController.php:19
* @route '/societies/{society}/settings'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\SettingsController::index
* @see app/Http/Controllers/SocietyAdmin/SettingsController.php:19
* @route '/societies/{society}/settings'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\SettingsController::update
* @see app/Http/Controllers/SocietyAdmin/SettingsController.php:41
* @route '/societies/{society}/settings'
*/
export const update = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/societies/{society}/settings',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\SettingsController::update
* @see app/Http/Controllers/SocietyAdmin/SettingsController.php:41
* @route '/societies/{society}/settings'
*/
update.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return update.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\SettingsController::update
* @see app/Http/Controllers/SocietyAdmin/SettingsController.php:41
* @route '/societies/{society}/settings'
*/
update.put = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\SettingsController::update
* @see app/Http/Controllers/SocietyAdmin/SettingsController.php:41
* @route '/societies/{society}/settings'
*/
const updateForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\SettingsController::update
* @see app/Http/Controllers/SocietyAdmin/SettingsController.php:41
* @route '/societies/{society}/settings'
*/
updateForm.put = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

const settings = {
    index: Object.assign(index, index),
    update: Object.assign(update, update),
}

export default settings