import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::index
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:24
* @route '/societies/{society}/residents'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/residents',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::index
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:24
* @route '/societies/{society}/residents'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::index
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:24
* @route '/societies/{society}/residents'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::index
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:24
* @route '/societies/{society}/residents'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::index
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:24
* @route '/societies/{society}/residents'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::index
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:24
* @route '/societies/{society}/residents'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::index
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:24
* @route '/societies/{society}/residents'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::create
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:108
* @route '/societies/{society}/residents/create'
*/
export const create = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/residents/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::create
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:108
* @route '/societies/{society}/residents/create'
*/
create.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return create.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::create
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:108
* @route '/societies/{society}/residents/create'
*/
create.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::create
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:108
* @route '/societies/{society}/residents/create'
*/
create.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::create
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:108
* @route '/societies/{society}/residents/create'
*/
const createForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::create
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:108
* @route '/societies/{society}/residents/create'
*/
createForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::create
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:108
* @route '/societies/{society}/residents/create'
*/
createForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::store
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:131
* @route '/societies/{society}/residents'
*/
export const store = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/societies/{society}/residents',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::store
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:131
* @route '/societies/{society}/residents'
*/
store.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return store.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::store
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:131
* @route '/societies/{society}/residents'
*/
store.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::store
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:131
* @route '/societies/{society}/residents'
*/
const storeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::store
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:131
* @route '/societies/{society}/residents'
*/
storeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::show
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:175
* @route '/societies/{society}/residents/{resident}'
*/
export const show = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/residents/{resident}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::show
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:175
* @route '/societies/{society}/residents/{resident}'
*/
show.url = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            resident: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        resident: typeof args.resident === 'object'
        ? args.resident.id
        : args.resident,
    }

    return show.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{resident}', parsedArgs.resident.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::show
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:175
* @route '/societies/{society}/residents/{resident}'
*/
show.get = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::show
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:175
* @route '/societies/{society}/residents/{resident}'
*/
show.head = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::show
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:175
* @route '/societies/{society}/residents/{resident}'
*/
const showForm = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::show
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:175
* @route '/societies/{society}/residents/{resident}'
*/
showForm.get = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::show
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:175
* @route '/societies/{society}/residents/{resident}'
*/
showForm.head = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::edit
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:205
* @route '/societies/{society}/residents/{resident}/edit'
*/
export const edit = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/residents/{resident}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::edit
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:205
* @route '/societies/{society}/residents/{resident}/edit'
*/
edit.url = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            resident: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        resident: typeof args.resident === 'object'
        ? args.resident.id
        : args.resident,
    }

    return edit.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{resident}', parsedArgs.resident.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::edit
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:205
* @route '/societies/{society}/residents/{resident}/edit'
*/
edit.get = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::edit
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:205
* @route '/societies/{society}/residents/{resident}/edit'
*/
edit.head = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::edit
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:205
* @route '/societies/{society}/residents/{resident}/edit'
*/
const editForm = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::edit
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:205
* @route '/societies/{society}/residents/{resident}/edit'
*/
editForm.get = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::edit
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:205
* @route '/societies/{society}/residents/{resident}/edit'
*/
editForm.head = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::update
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:236
* @route '/societies/{society}/residents/{resident}'
*/
export const update = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/societies/{society}/residents/{resident}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::update
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:236
* @route '/societies/{society}/residents/{resident}'
*/
update.url = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            resident: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        resident: typeof args.resident === 'object'
        ? args.resident.id
        : args.resident,
    }

    return update.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{resident}', parsedArgs.resident.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::update
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:236
* @route '/societies/{society}/residents/{resident}'
*/
update.put = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::update
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:236
* @route '/societies/{society}/residents/{resident}'
*/
update.patch = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::update
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:236
* @route '/societies/{society}/residents/{resident}'
*/
const updateForm = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::update
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:236
* @route '/societies/{society}/residents/{resident}'
*/
updateForm.put = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::update
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:236
* @route '/societies/{society}/residents/{resident}'
*/
updateForm.patch = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::destroy
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:294
* @route '/societies/{society}/residents/{resident}'
*/
export const destroy = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/societies/{society}/residents/{resident}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::destroy
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:294
* @route '/societies/{society}/residents/{resident}'
*/
destroy.url = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            resident: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        resident: typeof args.resident === 'object'
        ? args.resident.id
        : args.resident,
    }

    return destroy.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{resident}', parsedArgs.resident.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::destroy
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:294
* @route '/societies/{society}/residents/{resident}'
*/
destroy.delete = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::destroy
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:294
* @route '/societies/{society}/residents/{resident}'
*/
const destroyForm = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ResidentController::destroy
* @see app/Http/Controllers/SocietyAdmin/ResidentController.php:294
* @route '/societies/{society}/residents/{resident}'
*/
destroyForm.delete = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const residents = {
    index: Object.assign(index, index),
    create: Object.assign(create, create),
    store: Object.assign(store, store),
    show: Object.assign(show, show),
    edit: Object.assign(edit, edit),
    update: Object.assign(update, update),
    destroy: Object.assign(destroy, destroy),
}

export default residents