import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdSettingsController::update
* @see app/Http/Controllers/SocietyAdmin/AdminAdSettingsController.php:37
* @route '/societies/{society}/monetization/settings'
*/
export const update = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: update.url(args, options),
    method: 'post',
})

update.definition = {
    methods: ["post"],
    url: '/societies/{society}/monetization/settings',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdSettingsController::update
* @see app/Http/Controllers/SocietyAdmin/AdminAdSettingsController.php:37
* @route '/societies/{society}/monetization/settings'
*/
update.url = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
    }

    return update.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdSettingsController::update
* @see app/Http/Controllers/SocietyAdmin/AdminAdSettingsController.php:37
* @route '/societies/{society}/monetization/settings'
*/
update.post = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: update.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdSettingsController::update
* @see app/Http/Controllers/SocietyAdmin/AdminAdSettingsController.php:37
* @route '/societies/{society}/monetization/settings'
*/
const updateForm = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdSettingsController::update
* @see app/Http/Controllers/SocietyAdmin/AdminAdSettingsController.php:37
* @route '/societies/{society}/monetization/settings'
*/
updateForm.post = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, options),
    method: 'post',
})

update.form = updateForm

const settings = {
    update: Object.assign(update, update),
}

export default settings