import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
import settings69f00b from './settings'
/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::requests
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:17
* @route '/societies/{society}/monetization/requests'
*/
export const requests = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: requests.url(args, options),
    method: 'get',
})

requests.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/monetization/requests',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::requests
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:17
* @route '/societies/{society}/monetization/requests'
*/
requests.url = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
    }

    return requests.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::requests
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:17
* @route '/societies/{society}/monetization/requests'
*/
requests.get = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: requests.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::requests
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:17
* @route '/societies/{society}/monetization/requests'
*/
requests.head = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: requests.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::requests
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:17
* @route '/societies/{society}/monetization/requests'
*/
const requestsForm = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: requests.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::requests
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:17
* @route '/societies/{society}/monetization/requests'
*/
requestsForm.get = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: requests.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::requests
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:17
* @route '/societies/{society}/monetization/requests'
*/
requestsForm.head = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: requests.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

requests.form = requestsForm

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::approve
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:79
* @route '/societies/{society}/monetization/{advertisement}/approve'
*/
export const approve = (args: { society: string | number, advertisement: number | { id: number } } | [society: string | number, advertisement: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: approve.url(args, options),
    method: 'post',
})

approve.definition = {
    methods: ["post"],
    url: '/societies/{society}/monetization/{advertisement}/approve',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::approve
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:79
* @route '/societies/{society}/monetization/{advertisement}/approve'
*/
approve.url = (args: { society: string | number, advertisement: number | { id: number } } | [society: string | number, advertisement: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            advertisement: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
        advertisement: typeof args.advertisement === 'object'
        ? args.advertisement.id
        : args.advertisement,
    }

    return approve.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{advertisement}', parsedArgs.advertisement.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::approve
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:79
* @route '/societies/{society}/monetization/{advertisement}/approve'
*/
approve.post = (args: { society: string | number, advertisement: number | { id: number } } | [society: string | number, advertisement: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: approve.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::approve
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:79
* @route '/societies/{society}/monetization/{advertisement}/approve'
*/
const approveForm = (args: { society: string | number, advertisement: number | { id: number } } | [society: string | number, advertisement: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: approve.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::approve
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:79
* @route '/societies/{society}/monetization/{advertisement}/approve'
*/
approveForm.post = (args: { society: string | number, advertisement: number | { id: number } } | [society: string | number, advertisement: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: approve.url(args, options),
    method: 'post',
})

approve.form = approveForm

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::reject
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:140
* @route '/societies/{society}/monetization/{advertisement}/reject'
*/
export const reject = (args: { society: string | number, advertisement: number | { id: number } } | [society: string | number, advertisement: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: reject.url(args, options),
    method: 'post',
})

reject.definition = {
    methods: ["post"],
    url: '/societies/{society}/monetization/{advertisement}/reject',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::reject
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:140
* @route '/societies/{society}/monetization/{advertisement}/reject'
*/
reject.url = (args: { society: string | number, advertisement: number | { id: number } } | [society: string | number, advertisement: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            advertisement: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
        advertisement: typeof args.advertisement === 'object'
        ? args.advertisement.id
        : args.advertisement,
    }

    return reject.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{advertisement}', parsedArgs.advertisement.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::reject
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:140
* @route '/societies/{society}/monetization/{advertisement}/reject'
*/
reject.post = (args: { society: string | number, advertisement: number | { id: number } } | [society: string | number, advertisement: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: reject.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::reject
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:140
* @route '/societies/{society}/monetization/{advertisement}/reject'
*/
const rejectForm = (args: { society: string | number, advertisement: number | { id: number } } | [society: string | number, advertisement: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: reject.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::reject
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:140
* @route '/societies/{society}/monetization/{advertisement}/reject'
*/
rejectForm.post = (args: { society: string | number, advertisement: number | { id: number } } | [society: string | number, advertisement: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: reject.url(args, options),
    method: 'post',
})

reject.form = rejectForm

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdSettingsController::settings
* @see app/Http/Controllers/SocietyAdmin/AdminAdSettingsController.php:13
* @route '/societies/{society}/monetization/settings'
*/
export const settings = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: settings.url(args, options),
    method: 'get',
})

settings.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/monetization/settings',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdSettingsController::settings
* @see app/Http/Controllers/SocietyAdmin/AdminAdSettingsController.php:13
* @route '/societies/{society}/monetization/settings'
*/
settings.url = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
    }

    return settings.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdSettingsController::settings
* @see app/Http/Controllers/SocietyAdmin/AdminAdSettingsController.php:13
* @route '/societies/{society}/monetization/settings'
*/
settings.get = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: settings.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdSettingsController::settings
* @see app/Http/Controllers/SocietyAdmin/AdminAdSettingsController.php:13
* @route '/societies/{society}/monetization/settings'
*/
settings.head = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: settings.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdSettingsController::settings
* @see app/Http/Controllers/SocietyAdmin/AdminAdSettingsController.php:13
* @route '/societies/{society}/monetization/settings'
*/
const settingsForm = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: settings.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdSettingsController::settings
* @see app/Http/Controllers/SocietyAdmin/AdminAdSettingsController.php:13
* @route '/societies/{society}/monetization/settings'
*/
settingsForm.get = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: settings.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdSettingsController::settings
* @see app/Http/Controllers/SocietyAdmin/AdminAdSettingsController.php:13
* @route '/societies/{society}/monetization/settings'
*/
settingsForm.head = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: settings.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

settings.form = settingsForm

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::index
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:44
* @route '/societies/{society}/monetization'
*/
export const index = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/monetization',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::index
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:44
* @route '/societies/{society}/monetization'
*/
index.url = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::index
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:44
* @route '/societies/{society}/monetization'
*/
index.get = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::index
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:44
* @route '/societies/{society}/monetization'
*/
index.head = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::index
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:44
* @route '/societies/{society}/monetization'
*/
const indexForm = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::index
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:44
* @route '/societies/{society}/monetization'
*/
indexForm.get = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::index
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:44
* @route '/societies/{society}/monetization'
*/
indexForm.head = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::show
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:0
* @route '/societies/{society}/monetization/{monetization}'
*/
export const show = (args: { society: string | number, monetization: string | number } | [society: string | number, monetization: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/monetization/{monetization}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::show
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:0
* @route '/societies/{society}/monetization/{monetization}'
*/
show.url = (args: { society: string | number, monetization: string | number } | [society: string | number, monetization: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            monetization: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
        monetization: args.monetization,
    }

    return show.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{monetization}', parsedArgs.monetization.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::show
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:0
* @route '/societies/{society}/monetization/{monetization}'
*/
show.get = (args: { society: string | number, monetization: string | number } | [society: string | number, monetization: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::show
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:0
* @route '/societies/{society}/monetization/{monetization}'
*/
show.head = (args: { society: string | number, monetization: string | number } | [society: string | number, monetization: string | number ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::show
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:0
* @route '/societies/{society}/monetization/{monetization}'
*/
const showForm = (args: { society: string | number, monetization: string | number } | [society: string | number, monetization: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::show
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:0
* @route '/societies/{society}/monetization/{monetization}'
*/
showForm.get = (args: { society: string | number, monetization: string | number } | [society: string | number, monetization: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::show
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:0
* @route '/societies/{society}/monetization/{monetization}'
*/
showForm.head = (args: { society: string | number, monetization: string | number } | [society: string | number, monetization: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::destroy
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:157
* @route '/societies/{society}/monetization/{monetization}'
*/
export const destroy = (args: { society: string | number, monetization: string | number } | [society: string | number, monetization: string | number ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/societies/{society}/monetization/{monetization}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::destroy
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:157
* @route '/societies/{society}/monetization/{monetization}'
*/
destroy.url = (args: { society: string | number, monetization: string | number } | [society: string | number, monetization: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            monetization: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
        monetization: args.monetization,
    }

    return destroy.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{monetization}', parsedArgs.monetization.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::destroy
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:157
* @route '/societies/{society}/monetization/{monetization}'
*/
destroy.delete = (args: { society: string | number, monetization: string | number } | [society: string | number, monetization: string | number ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::destroy
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:157
* @route '/societies/{society}/monetization/{monetization}'
*/
const destroyForm = (args: { society: string | number, monetization: string | number } | [society: string | number, monetization: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AdminAdController::destroy
* @see app/Http/Controllers/SocietyAdmin/AdminAdController.php:157
* @route '/societies/{society}/monetization/{monetization}'
*/
destroyForm.delete = (args: { society: string | number, monetization: string | number } | [society: string | number, monetization: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const monetization = {
    requests: Object.assign(requests, requests),
    approve: Object.assign(approve, approve),
    reject: Object.assign(reject, reject),
    settings: Object.assign(settings, settings69f00b),
    index: Object.assign(index, index),
    show: Object.assign(show, show),
    destroy: Object.assign(destroy, destroy),
}

export default monetization