import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::index
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:22
* @route '/societies/{society}/maintenance'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/maintenance',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::index
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:22
* @route '/societies/{society}/maintenance'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::index
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:22
* @route '/societies/{society}/maintenance'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::index
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:22
* @route '/societies/{society}/maintenance'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::index
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:22
* @route '/societies/{society}/maintenance'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::index
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:22
* @route '/societies/{society}/maintenance'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::index
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:22
* @route '/societies/{society}/maintenance'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::create
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:106
* @route '/societies/{society}/maintenance/create'
*/
export const create = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/maintenance/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::create
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:106
* @route '/societies/{society}/maintenance/create'
*/
create.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return create.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::create
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:106
* @route '/societies/{society}/maintenance/create'
*/
create.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::create
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:106
* @route '/societies/{society}/maintenance/create'
*/
create.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::create
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:106
* @route '/societies/{society}/maintenance/create'
*/
const createForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::create
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:106
* @route '/societies/{society}/maintenance/create'
*/
createForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::create
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:106
* @route '/societies/{society}/maintenance/create'
*/
createForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::store
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:145
* @route '/societies/{society}/maintenance'
*/
export const store = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/societies/{society}/maintenance',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::store
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:145
* @route '/societies/{society}/maintenance'
*/
store.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return store.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::store
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:145
* @route '/societies/{society}/maintenance'
*/
store.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::store
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:145
* @route '/societies/{society}/maintenance'
*/
const storeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::store
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:145
* @route '/societies/{society}/maintenance'
*/
storeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::show
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:183
* @route '/societies/{society}/maintenance/{maintenance}'
*/
export const show = (args: { society: number | { id: number }, maintenance: string | number } | [society: number | { id: number }, maintenance: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/maintenance/{maintenance}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::show
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:183
* @route '/societies/{society}/maintenance/{maintenance}'
*/
show.url = (args: { society: number | { id: number }, maintenance: string | number } | [society: number | { id: number }, maintenance: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            maintenance: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        maintenance: args.maintenance,
    }

    return show.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{maintenance}', parsedArgs.maintenance.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::show
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:183
* @route '/societies/{society}/maintenance/{maintenance}'
*/
show.get = (args: { society: number | { id: number }, maintenance: string | number } | [society: number | { id: number }, maintenance: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::show
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:183
* @route '/societies/{society}/maintenance/{maintenance}'
*/
show.head = (args: { society: number | { id: number }, maintenance: string | number } | [society: number | { id: number }, maintenance: string | number ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::show
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:183
* @route '/societies/{society}/maintenance/{maintenance}'
*/
const showForm = (args: { society: number | { id: number }, maintenance: string | number } | [society: number | { id: number }, maintenance: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::show
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:183
* @route '/societies/{society}/maintenance/{maintenance}'
*/
showForm.get = (args: { society: number | { id: number }, maintenance: string | number } | [society: number | { id: number }, maintenance: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::show
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:183
* @route '/societies/{society}/maintenance/{maintenance}'
*/
showForm.head = (args: { society: number | { id: number }, maintenance: string | number } | [society: number | { id: number }, maintenance: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::updateStatus
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:252
* @route '/societies/{society}/maintenance/{maintenanceTicket}/update-status'
*/
export const updateStatus = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: updateStatus.url(args, options),
    method: 'post',
})

updateStatus.definition = {
    methods: ["post"],
    url: '/societies/{society}/maintenance/{maintenanceTicket}/update-status',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::updateStatus
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:252
* @route '/societies/{society}/maintenance/{maintenanceTicket}/update-status'
*/
updateStatus.url = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            maintenanceTicket: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        maintenanceTicket: typeof args.maintenanceTicket === 'object'
        ? args.maintenanceTicket.id
        : args.maintenanceTicket,
    }

    return updateStatus.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{maintenanceTicket}', parsedArgs.maintenanceTicket.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::updateStatus
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:252
* @route '/societies/{society}/maintenance/{maintenanceTicket}/update-status'
*/
updateStatus.post = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: updateStatus.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::updateStatus
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:252
* @route '/societies/{society}/maintenance/{maintenanceTicket}/update-status'
*/
const updateStatusForm = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateStatus.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::updateStatus
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:252
* @route '/societies/{society}/maintenance/{maintenanceTicket}/update-status'
*/
updateStatusForm.post = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateStatus.url(args, options),
    method: 'post',
})

updateStatus.form = updateStatusForm

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::assignVendor
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:284
* @route '/societies/{society}/maintenance/{maintenanceTicket}/assign-vendor'
*/
export const assignVendor = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: assignVendor.url(args, options),
    method: 'post',
})

assignVendor.definition = {
    methods: ["post"],
    url: '/societies/{society}/maintenance/{maintenanceTicket}/assign-vendor',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::assignVendor
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:284
* @route '/societies/{society}/maintenance/{maintenanceTicket}/assign-vendor'
*/
assignVendor.url = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            maintenanceTicket: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        maintenanceTicket: typeof args.maintenanceTicket === 'object'
        ? args.maintenanceTicket.id
        : args.maintenanceTicket,
    }

    return assignVendor.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{maintenanceTicket}', parsedArgs.maintenanceTicket.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::assignVendor
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:284
* @route '/societies/{society}/maintenance/{maintenanceTicket}/assign-vendor'
*/
assignVendor.post = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: assignVendor.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::assignVendor
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:284
* @route '/societies/{society}/maintenance/{maintenanceTicket}/assign-vendor'
*/
const assignVendorForm = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: assignVendor.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::assignVendor
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:284
* @route '/societies/{society}/maintenance/{maintenanceTicket}/assign-vendor'
*/
assignVendorForm.post = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: assignVendor.url(args, options),
    method: 'post',
})

assignVendor.form = assignVendorForm

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::resolve
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:317
* @route '/societies/{society}/maintenance/{maintenanceTicket}/resolve'
*/
export const resolve = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: resolve.url(args, options),
    method: 'post',
})

resolve.definition = {
    methods: ["post"],
    url: '/societies/{society}/maintenance/{maintenanceTicket}/resolve',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::resolve
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:317
* @route '/societies/{society}/maintenance/{maintenanceTicket}/resolve'
*/
resolve.url = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            maintenanceTicket: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        maintenanceTicket: typeof args.maintenanceTicket === 'object'
        ? args.maintenanceTicket.id
        : args.maintenanceTicket,
    }

    return resolve.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{maintenanceTicket}', parsedArgs.maintenanceTicket.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::resolve
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:317
* @route '/societies/{society}/maintenance/{maintenanceTicket}/resolve'
*/
resolve.post = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: resolve.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::resolve
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:317
* @route '/societies/{society}/maintenance/{maintenanceTicket}/resolve'
*/
const resolveForm = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: resolve.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceController::resolve
* @see app/Http/Controllers/SocietyAdmin/MaintenanceController.php:317
* @route '/societies/{society}/maintenance/{maintenanceTicket}/resolve'
*/
resolveForm.post = (args: { society: number | { id: number }, maintenanceTicket: number | { id: number } } | [society: number | { id: number }, maintenanceTicket: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: resolve.url(args, options),
    method: 'post',
})

resolve.form = resolveForm

const maintenance = {
    index: Object.assign(index, index),
    create: Object.assign(create, create),
    store: Object.assign(store, store),
    show: Object.assign(show, show),
    updateStatus: Object.assign(updateStatus, updateStatus),
    assignVendor: Object.assign(assignVendor, assignVendor),
    resolve: Object.assign(resolve, resolve),
}

export default maintenance