import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../wayfinder'
import residents from './residents'
import buildings from './buildings'
import units from './units'
import maintenance from './maintenance'
import visitors from './visitors'
import announcements from './announcements'
import community from './community'
import emergency from './emergency'
import billCycles from './bill-cycles'
import maintenanceStructures from './maintenance-structures'
import bills from './bills'
import payments from './payments'
import bankAccounts from './bank-accounts'
import expenses from './expenses'
import reports from './reports'
import revenue from './revenue'
import team from './team'
import settings from './settings'
import monetization from './monetization'
import facilities from './facilities'
import facilityBookings from './facility-bookings'
import collectors from './collectors'
import directory from './directory'
/**
* @see \App\Http\Controllers\SocietyAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SocietyAdmin/DashboardController.php:20
* @route '/societies/{society}/dashboard'
*/
export const dashboard = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: dashboard.url(args, options),
    method: 'get',
})

dashboard.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/dashboard',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SocietyAdmin/DashboardController.php:20
* @route '/societies/{society}/dashboard'
*/
dashboard.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return dashboard.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SocietyAdmin/DashboardController.php:20
* @route '/societies/{society}/dashboard'
*/
dashboard.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: dashboard.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SocietyAdmin/DashboardController.php:20
* @route '/societies/{society}/dashboard'
*/
dashboard.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: dashboard.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SocietyAdmin/DashboardController.php:20
* @route '/societies/{society}/dashboard'
*/
const dashboardForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dashboard.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SocietyAdmin/DashboardController.php:20
* @route '/societies/{society}/dashboard'
*/
dashboardForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dashboard.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\DashboardController::dashboard
* @see app/Http/Controllers/SocietyAdmin/DashboardController.php:20
* @route '/societies/{society}/dashboard'
*/
dashboardForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dashboard.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

dashboard.form = dashboardForm

const society = {
    dashboard: Object.assign(dashboard, dashboard),
    residents: Object.assign(residents, residents),
    buildings: Object.assign(buildings, buildings),
    units: Object.assign(units, units),
    maintenance: Object.assign(maintenance, maintenance),
    visitors: Object.assign(visitors, visitors),
    announcements: Object.assign(announcements, announcements),
    community: Object.assign(community, community),
    emergency: Object.assign(emergency, emergency),
    billCycles: Object.assign(billCycles, billCycles),
    maintenanceStructures: Object.assign(maintenanceStructures, maintenanceStructures),
    bills: Object.assign(bills, bills),
    payments: Object.assign(payments, payments),
    bankAccounts: Object.assign(bankAccounts, bankAccounts),
    expenses: Object.assign(expenses, expenses),
    reports: Object.assign(reports, reports),
    revenue: Object.assign(revenue, revenue),
    team: Object.assign(team, team),
    settings: Object.assign(settings, settings),
    monetization: Object.assign(monetization, monetization),
    facilities: Object.assign(facilities, facilities),
    facilityBookings: Object.assign(facilityBookings, facilityBookings),
    collectors: Object.assign(collectors, collectors),
    directory: Object.assign(directory, directory),
}

export default society