import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::index
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:227
* @route '/societies/{society}/facility-bookings'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/facility-bookings',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::index
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:227
* @route '/societies/{society}/facility-bookings'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::index
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:227
* @route '/societies/{society}/facility-bookings'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::index
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:227
* @route '/societies/{society}/facility-bookings'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::index
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:227
* @route '/societies/{society}/facility-bookings'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::index
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:227
* @route '/societies/{society}/facility-bookings'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::index
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:227
* @route '/societies/{society}/facility-bookings'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::show
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:269
* @route '/societies/{society}/facility-bookings/{booking}'
*/
export const show = (args: { society: number | { id: number }, booking: number | { id: number } } | [society: number | { id: number }, booking: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/facility-bookings/{booking}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::show
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:269
* @route '/societies/{society}/facility-bookings/{booking}'
*/
show.url = (args: { society: number | { id: number }, booking: number | { id: number } } | [society: number | { id: number }, booking: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            booking: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        booking: typeof args.booking === 'object'
        ? args.booking.id
        : args.booking,
    }

    return show.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{booking}', parsedArgs.booking.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::show
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:269
* @route '/societies/{society}/facility-bookings/{booking}'
*/
show.get = (args: { society: number | { id: number }, booking: number | { id: number } } | [society: number | { id: number }, booking: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::show
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:269
* @route '/societies/{society}/facility-bookings/{booking}'
*/
show.head = (args: { society: number | { id: number }, booking: number | { id: number } } | [society: number | { id: number }, booking: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::show
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:269
* @route '/societies/{society}/facility-bookings/{booking}'
*/
const showForm = (args: { society: number | { id: number }, booking: number | { id: number } } | [society: number | { id: number }, booking: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::show
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:269
* @route '/societies/{society}/facility-bookings/{booking}'
*/
showForm.get = (args: { society: number | { id: number }, booking: number | { id: number } } | [society: number | { id: number }, booking: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::show
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:269
* @route '/societies/{society}/facility-bookings/{booking}'
*/
showForm.head = (args: { society: number | { id: number }, booking: number | { id: number } } | [society: number | { id: number }, booking: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::updateStatus
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:281
* @route '/societies/{society}/facility-bookings/{booking}/status'
*/
export const updateStatus = (args: { society: number | { id: number }, booking: number | { id: number } } | [society: number | { id: number }, booking: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: updateStatus.url(args, options),
    method: 'post',
})

updateStatus.definition = {
    methods: ["post"],
    url: '/societies/{society}/facility-bookings/{booking}/status',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::updateStatus
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:281
* @route '/societies/{society}/facility-bookings/{booking}/status'
*/
updateStatus.url = (args: { society: number | { id: number }, booking: number | { id: number } } | [society: number | { id: number }, booking: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            booking: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        booking: typeof args.booking === 'object'
        ? args.booking.id
        : args.booking,
    }

    return updateStatus.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{booking}', parsedArgs.booking.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::updateStatus
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:281
* @route '/societies/{society}/facility-bookings/{booking}/status'
*/
updateStatus.post = (args: { society: number | { id: number }, booking: number | { id: number } } | [society: number | { id: number }, booking: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: updateStatus.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::updateStatus
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:281
* @route '/societies/{society}/facility-bookings/{booking}/status'
*/
const updateStatusForm = (args: { society: number | { id: number }, booking: number | { id: number } } | [society: number | { id: number }, booking: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateStatus.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::updateStatus
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:281
* @route '/societies/{society}/facility-bookings/{booking}/status'
*/
updateStatusForm.post = (args: { society: number | { id: number }, booking: number | { id: number } } | [society: number | { id: number }, booking: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateStatus.url(args, options),
    method: 'post',
})

updateStatus.form = updateStatusForm

const facilityBookings = {
    index: Object.assign(index, index),
    show: Object.assign(show, show),
    updateStatus: Object.assign(updateStatus, updateStatus),
}

export default facilityBookings