import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::index
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:19
* @route '/societies/{society}/facilities'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/facilities',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::index
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:19
* @route '/societies/{society}/facilities'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::index
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:19
* @route '/societies/{society}/facilities'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::index
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:19
* @route '/societies/{society}/facilities'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::index
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:19
* @route '/societies/{society}/facilities'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::index
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:19
* @route '/societies/{society}/facilities'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::index
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:19
* @route '/societies/{society}/facilities'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::create
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:36
* @route '/societies/{society}/facilities/create'
*/
export const create = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/facilities/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::create
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:36
* @route '/societies/{society}/facilities/create'
*/
create.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return create.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::create
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:36
* @route '/societies/{society}/facilities/create'
*/
create.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::create
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:36
* @route '/societies/{society}/facilities/create'
*/
create.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::create
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:36
* @route '/societies/{society}/facilities/create'
*/
const createForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::create
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:36
* @route '/societies/{society}/facilities/create'
*/
createForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::create
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:36
* @route '/societies/{society}/facilities/create'
*/
createForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::store
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:46
* @route '/societies/{society}/facilities'
*/
export const store = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/societies/{society}/facilities',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::store
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:46
* @route '/societies/{society}/facilities'
*/
store.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return store.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::store
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:46
* @route '/societies/{society}/facilities'
*/
store.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::store
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:46
* @route '/societies/{society}/facilities'
*/
const storeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::store
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:46
* @route '/societies/{society}/facilities'
*/
storeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::show
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:73
* @route '/societies/{society}/facilities/{facility}'
*/
export const show = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/facilities/{facility}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::show
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:73
* @route '/societies/{society}/facilities/{facility}'
*/
show.url = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            facility: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        facility: typeof args.facility === 'object'
        ? args.facility.id
        : args.facility,
    }

    return show.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{facility}', parsedArgs.facility.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::show
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:73
* @route '/societies/{society}/facilities/{facility}'
*/
show.get = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::show
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:73
* @route '/societies/{society}/facilities/{facility}'
*/
show.head = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::show
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:73
* @route '/societies/{society}/facilities/{facility}'
*/
const showForm = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::show
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:73
* @route '/societies/{society}/facilities/{facility}'
*/
showForm.get = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::show
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:73
* @route '/societies/{society}/facilities/{facility}'
*/
showForm.head = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::edit
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:105
* @route '/societies/{society}/facilities/{facility}/edit'
*/
export const edit = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/facilities/{facility}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::edit
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:105
* @route '/societies/{society}/facilities/{facility}/edit'
*/
edit.url = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            facility: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        facility: typeof args.facility === 'object'
        ? args.facility.id
        : args.facility,
    }

    return edit.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{facility}', parsedArgs.facility.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::edit
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:105
* @route '/societies/{society}/facilities/{facility}/edit'
*/
edit.get = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::edit
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:105
* @route '/societies/{society}/facilities/{facility}/edit'
*/
edit.head = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::edit
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:105
* @route '/societies/{society}/facilities/{facility}/edit'
*/
const editForm = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::edit
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:105
* @route '/societies/{society}/facilities/{facility}/edit'
*/
editForm.get = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::edit
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:105
* @route '/societies/{society}/facilities/{facility}/edit'
*/
editForm.head = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::update
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:116
* @route '/societies/{society}/facilities/{facility}'
*/
export const update = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/societies/{society}/facilities/{facility}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::update
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:116
* @route '/societies/{society}/facilities/{facility}'
*/
update.url = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            facility: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        facility: typeof args.facility === 'object'
        ? args.facility.id
        : args.facility,
    }

    return update.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{facility}', parsedArgs.facility.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::update
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:116
* @route '/societies/{society}/facilities/{facility}'
*/
update.put = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::update
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:116
* @route '/societies/{society}/facilities/{facility}'
*/
update.patch = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::update
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:116
* @route '/societies/{society}/facilities/{facility}'
*/
const updateForm = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::update
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:116
* @route '/societies/{society}/facilities/{facility}'
*/
updateForm.put = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::update
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:116
* @route '/societies/{society}/facilities/{facility}'
*/
updateForm.patch = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::destroy
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:141
* @route '/societies/{society}/facilities/{facility}'
*/
export const destroy = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/societies/{society}/facilities/{facility}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::destroy
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:141
* @route '/societies/{society}/facilities/{facility}'
*/
destroy.url = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            facility: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        facility: typeof args.facility === 'object'
        ? args.facility.id
        : args.facility,
    }

    return destroy.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{facility}', parsedArgs.facility.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::destroy
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:141
* @route '/societies/{society}/facilities/{facility}'
*/
destroy.delete = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::destroy
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:141
* @route '/societies/{society}/facilities/{facility}'
*/
const destroyForm = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::destroy
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:141
* @route '/societies/{society}/facilities/{facility}'
*/
destroyForm.delete = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::manageSlots
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:162
* @route '/societies/{society}/facilities/{facility}/slots'
*/
export const manageSlots = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: manageSlots.url(args, options),
    method: 'post',
})

manageSlots.definition = {
    methods: ["post"],
    url: '/societies/{society}/facilities/{facility}/slots',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::manageSlots
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:162
* @route '/societies/{society}/facilities/{facility}/slots'
*/
manageSlots.url = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            facility: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        facility: typeof args.facility === 'object'
        ? args.facility.id
        : args.facility,
    }

    return manageSlots.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{facility}', parsedArgs.facility.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::manageSlots
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:162
* @route '/societies/{society}/facilities/{facility}/slots'
*/
manageSlots.post = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: manageSlots.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::manageSlots
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:162
* @route '/societies/{society}/facilities/{facility}/slots'
*/
const manageSlotsForm = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: manageSlots.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::manageSlots
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:162
* @route '/societies/{society}/facilities/{facility}/slots'
*/
manageSlotsForm.post = (args: { society: number | { id: number }, facility: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: manageSlots.url(args, options),
    method: 'post',
})

manageSlots.form = manageSlotsForm

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::deleteSlot
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:207
* @route '/societies/{society}/facilities/{facility}/slots/{slot}'
*/
export const deleteSlot = (args: { society: number | { id: number }, facility: number | { id: number }, slot: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number }, slot: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: deleteSlot.url(args, options),
    method: 'delete',
})

deleteSlot.definition = {
    methods: ["delete"],
    url: '/societies/{society}/facilities/{facility}/slots/{slot}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::deleteSlot
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:207
* @route '/societies/{society}/facilities/{facility}/slots/{slot}'
*/
deleteSlot.url = (args: { society: number | { id: number }, facility: number | { id: number }, slot: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number }, slot: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            facility: args[1],
            slot: args[2],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        facility: typeof args.facility === 'object'
        ? args.facility.id
        : args.facility,
        slot: typeof args.slot === 'object'
        ? args.slot.id
        : args.slot,
    }

    return deleteSlot.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{facility}', parsedArgs.facility.toString())
            .replace('{slot}', parsedArgs.slot.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::deleteSlot
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:207
* @route '/societies/{society}/facilities/{facility}/slots/{slot}'
*/
deleteSlot.delete = (args: { society: number | { id: number }, facility: number | { id: number }, slot: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number }, slot: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: deleteSlot.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::deleteSlot
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:207
* @route '/societies/{society}/facilities/{facility}/slots/{slot}'
*/
const deleteSlotForm = (args: { society: number | { id: number }, facility: number | { id: number }, slot: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number }, slot: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: deleteSlot.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\FacilityController::deleteSlot
* @see app/Http/Controllers/SocietyAdmin/FacilityController.php:207
* @route '/societies/{society}/facilities/{facility}/slots/{slot}'
*/
deleteSlotForm.delete = (args: { society: number | { id: number }, facility: number | { id: number }, slot: number | { id: number } } | [society: number | { id: number }, facility: number | { id: number }, slot: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: deleteSlot.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

deleteSlot.form = deleteSlotForm

const facilities = {
    index: Object.assign(index, index),
    create: Object.assign(create, create),
    store: Object.assign(store, store),
    show: Object.assign(show, show),
    edit: Object.assign(edit, edit),
    update: Object.assign(update, update),
    destroy: Object.assign(destroy, destroy),
    manageSlots: Object.assign(manageSlots, manageSlots),
    deleteSlot: Object.assign(deleteSlot, deleteSlot),
}

export default facilities