import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/societies/{society}/emergency/active'
*/
export const active = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: active.url(args, options),
    method: 'get',
})

active.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/emergency/active',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/societies/{society}/emergency/active'
*/
active.url = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
    }

    return active.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/societies/{society}/emergency/active'
*/
active.get = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: active.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/societies/{society}/emergency/active'
*/
active.head = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: active.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/societies/{society}/emergency/active'
*/
const activeForm = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: active.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/societies/{society}/emergency/active'
*/
activeForm.get = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: active.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/societies/{society}/emergency/active'
*/
activeForm.head = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: active.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

active.form = activeForm

/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/societies/{society}/emergency/{id}/resolve'
*/
export const resolve = (args: { society: string | number, id: string | number } | [society: string | number, id: string | number ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: resolve.url(args, options),
    method: 'post',
})

resolve.definition = {
    methods: ["post"],
    url: '/societies/{society}/emergency/{id}/resolve',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/societies/{society}/emergency/{id}/resolve'
*/
resolve.url = (args: { society: string | number, id: string | number } | [society: string | number, id: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            id: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
        id: args.id,
    }

    return resolve.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/societies/{society}/emergency/{id}/resolve'
*/
resolve.post = (args: { society: string | number, id: string | number } | [society: string | number, id: string | number ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: resolve.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/societies/{society}/emergency/{id}/resolve'
*/
const resolveForm = (args: { society: string | number, id: string | number } | [society: string | number, id: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: resolve.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/societies/{society}/emergency/{id}/resolve'
*/
resolveForm.post = (args: { society: string | number, id: string | number } | [society: string | number, id: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: resolve.url(args, options),
    method: 'post',
})

resolve.form = resolveForm

const emergency = {
    active: Object.assign(active, active),
    resolve: Object.assign(resolve, resolve),
}

export default emergency