import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::show
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:102
* @route '/societies/{society}/collectors/{collector}/wallet'
*/
export const show = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/collectors/{collector}/wallet',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::show
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:102
* @route '/societies/{society}/collectors/{collector}/wallet'
*/
show.url = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            collector: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        collector: args.collector,
    }

    return show.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{collector}', parsedArgs.collector.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::show
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:102
* @route '/societies/{society}/collectors/{collector}/wallet'
*/
show.get = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::show
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:102
* @route '/societies/{society}/collectors/{collector}/wallet'
*/
show.head = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::show
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:102
* @route '/societies/{society}/collectors/{collector}/wallet'
*/
const showForm = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::show
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:102
* @route '/societies/{society}/collectors/{collector}/wallet'
*/
showForm.get = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::show
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:102
* @route '/societies/{society}/collectors/{collector}/wallet'
*/
showForm.head = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

const wallet = {
    show: Object.assign(show, show),
}

export default wallet