import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
import wallet from './wallet'
/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::wallets
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:22
* @route '/societies/{society}/collectors/wallets'
*/
export const wallets = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: wallets.url(args, options),
    method: 'get',
})

wallets.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/collectors/wallets',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::wallets
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:22
* @route '/societies/{society}/collectors/wallets'
*/
wallets.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return wallets.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::wallets
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:22
* @route '/societies/{society}/collectors/wallets'
*/
wallets.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: wallets.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::wallets
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:22
* @route '/societies/{society}/collectors/wallets'
*/
wallets.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: wallets.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::wallets
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:22
* @route '/societies/{society}/collectors/wallets'
*/
const walletsForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: wallets.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::wallets
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:22
* @route '/societies/{society}/collectors/wallets'
*/
walletsForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: wallets.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::wallets
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:22
* @route '/societies/{society}/collectors/wallets'
*/
walletsForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: wallets.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

wallets.form = walletsForm

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::handover
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:239
* @route '/societies/{society}/collectors/{collector}/handover'
*/
export const handover = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: handover.url(args, options),
    method: 'post',
})

handover.definition = {
    methods: ["post"],
    url: '/societies/{society}/collectors/{collector}/handover',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::handover
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:239
* @route '/societies/{society}/collectors/{collector}/handover'
*/
handover.url = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            collector: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        collector: args.collector,
    }

    return handover.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{collector}', parsedArgs.collector.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::handover
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:239
* @route '/societies/{society}/collectors/{collector}/handover'
*/
handover.post = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: handover.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::handover
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:239
* @route '/societies/{society}/collectors/{collector}/handover'
*/
const handoverForm = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: handover.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::handover
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:239
* @route '/societies/{society}/collectors/{collector}/handover'
*/
handoverForm.post = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: handover.url(args, options),
    method: 'post',
})

handover.form = handoverForm

const collectors = {
    wallets: Object.assign(wallets, wallets),
    wallet: Object.assign(wallet, wallet),
    handover: Object.assign(handover, handover),
}

export default collectors