import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::index
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:22
* @route '/societies/{society}/buildings'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/buildings',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::index
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:22
* @route '/societies/{society}/buildings'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::index
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:22
* @route '/societies/{society}/buildings'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::index
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:22
* @route '/societies/{society}/buildings'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::index
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:22
* @route '/societies/{society}/buildings'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::index
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:22
* @route '/societies/{society}/buildings'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::index
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:22
* @route '/societies/{society}/buildings'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::create
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:65
* @route '/societies/{society}/buildings/create'
*/
export const create = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/buildings/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::create
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:65
* @route '/societies/{society}/buildings/create'
*/
create.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return create.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::create
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:65
* @route '/societies/{society}/buildings/create'
*/
create.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::create
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:65
* @route '/societies/{society}/buildings/create'
*/
create.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::create
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:65
* @route '/societies/{society}/buildings/create'
*/
const createForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::create
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:65
* @route '/societies/{society}/buildings/create'
*/
createForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::create
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:65
* @route '/societies/{society}/buildings/create'
*/
createForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::store
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:81
* @route '/societies/{society}/buildings'
*/
export const store = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/societies/{society}/buildings',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::store
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:81
* @route '/societies/{society}/buildings'
*/
store.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return store.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::store
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:81
* @route '/societies/{society}/buildings'
*/
store.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::store
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:81
* @route '/societies/{society}/buildings'
*/
const storeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::store
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:81
* @route '/societies/{society}/buildings'
*/
storeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::show
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:101
* @route '/societies/{society}/buildings/{building}'
*/
export const show = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/buildings/{building}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::show
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:101
* @route '/societies/{society}/buildings/{building}'
*/
show.url = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            building: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        building: typeof args.building === 'object'
        ? args.building.id
        : args.building,
    }

    return show.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{building}', parsedArgs.building.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::show
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:101
* @route '/societies/{society}/buildings/{building}'
*/
show.get = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::show
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:101
* @route '/societies/{society}/buildings/{building}'
*/
show.head = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::show
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:101
* @route '/societies/{society}/buildings/{building}'
*/
const showForm = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::show
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:101
* @route '/societies/{society}/buildings/{building}'
*/
showForm.get = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::show
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:101
* @route '/societies/{society}/buildings/{building}'
*/
showForm.head = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::edit
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:120
* @route '/societies/{society}/buildings/{building}/edit'
*/
export const edit = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/buildings/{building}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::edit
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:120
* @route '/societies/{society}/buildings/{building}/edit'
*/
edit.url = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            building: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        building: typeof args.building === 'object'
        ? args.building.id
        : args.building,
    }

    return edit.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{building}', parsedArgs.building.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::edit
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:120
* @route '/societies/{society}/buildings/{building}/edit'
*/
edit.get = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::edit
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:120
* @route '/societies/{society}/buildings/{building}/edit'
*/
edit.head = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::edit
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:120
* @route '/societies/{society}/buildings/{building}/edit'
*/
const editForm = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::edit
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:120
* @route '/societies/{society}/buildings/{building}/edit'
*/
editForm.get = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::edit
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:120
* @route '/societies/{society}/buildings/{building}/edit'
*/
editForm.head = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::update
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:137
* @route '/societies/{society}/buildings/{building}'
*/
export const update = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/societies/{society}/buildings/{building}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::update
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:137
* @route '/societies/{society}/buildings/{building}'
*/
update.url = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            building: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        building: typeof args.building === 'object'
        ? args.building.id
        : args.building,
    }

    return update.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{building}', parsedArgs.building.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::update
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:137
* @route '/societies/{society}/buildings/{building}'
*/
update.put = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::update
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:137
* @route '/societies/{society}/buildings/{building}'
*/
update.patch = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::update
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:137
* @route '/societies/{society}/buildings/{building}'
*/
const updateForm = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::update
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:137
* @route '/societies/{society}/buildings/{building}'
*/
updateForm.put = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::update
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:137
* @route '/societies/{society}/buildings/{building}'
*/
updateForm.patch = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::destroy
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:154
* @route '/societies/{society}/buildings/{building}'
*/
export const destroy = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/societies/{society}/buildings/{building}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::destroy
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:154
* @route '/societies/{society}/buildings/{building}'
*/
destroy.url = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            building: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        building: typeof args.building === 'object'
        ? args.building.id
        : args.building,
    }

    return destroy.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{building}', parsedArgs.building.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::destroy
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:154
* @route '/societies/{society}/buildings/{building}'
*/
destroy.delete = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::destroy
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:154
* @route '/societies/{society}/buildings/{building}'
*/
const destroyForm = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BuildingController::destroy
* @see app/Http/Controllers/SocietyAdmin/BuildingController.php:154
* @route '/societies/{society}/buildings/{building}'
*/
destroyForm.delete = (args: { society: number | { id: number }, building: number | { id: number } } | [society: number | { id: number }, building: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const buildings = {
    index: Object.assign(index, index),
    create: Object.assign(create, create),
    store: Object.assign(store, store),
    show: Object.assign(show, show),
    edit: Object.assign(edit, edit),
    update: Object.assign(update, update),
    destroy: Object.assign(destroy, destroy),
}

export default buildings