import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::index
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:24
* @route '/societies/{society}/bill-cycles'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/bill-cycles',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::index
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:24
* @route '/societies/{society}/bill-cycles'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::index
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:24
* @route '/societies/{society}/bill-cycles'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::index
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:24
* @route '/societies/{society}/bill-cycles'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::index
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:24
* @route '/societies/{society}/bill-cycles'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::index
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:24
* @route '/societies/{society}/bill-cycles'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::index
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:24
* @route '/societies/{society}/bill-cycles'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::create
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:72
* @route '/societies/{society}/bill-cycles/create'
*/
export const create = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/bill-cycles/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::create
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:72
* @route '/societies/{society}/bill-cycles/create'
*/
create.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return create.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::create
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:72
* @route '/societies/{society}/bill-cycles/create'
*/
create.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::create
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:72
* @route '/societies/{society}/bill-cycles/create'
*/
create.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::create
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:72
* @route '/societies/{society}/bill-cycles/create'
*/
const createForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::create
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:72
* @route '/societies/{society}/bill-cycles/create'
*/
createForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::create
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:72
* @route '/societies/{society}/bill-cycles/create'
*/
createForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::store
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:94
* @route '/societies/{society}/bill-cycles'
*/
export const store = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/societies/{society}/bill-cycles',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::store
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:94
* @route '/societies/{society}/bill-cycles'
*/
store.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return store.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::store
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:94
* @route '/societies/{society}/bill-cycles'
*/
store.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::store
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:94
* @route '/societies/{society}/bill-cycles'
*/
const storeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::store
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:94
* @route '/societies/{society}/bill-cycles'
*/
storeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::generate
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:120
* @route '/societies/{society}/bill-cycles/{billCycle}/generate'
*/
export const generate = (args: { society: number | { id: number }, billCycle: number | { id: number } } | [society: number | { id: number }, billCycle: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: generate.url(args, options),
    method: 'post',
})

generate.definition = {
    methods: ["post"],
    url: '/societies/{society}/bill-cycles/{billCycle}/generate',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::generate
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:120
* @route '/societies/{society}/bill-cycles/{billCycle}/generate'
*/
generate.url = (args: { society: number | { id: number }, billCycle: number | { id: number } } | [society: number | { id: number }, billCycle: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            billCycle: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        billCycle: typeof args.billCycle === 'object'
        ? args.billCycle.id
        : args.billCycle,
    }

    return generate.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{billCycle}', parsedArgs.billCycle.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::generate
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:120
* @route '/societies/{society}/bill-cycles/{billCycle}/generate'
*/
generate.post = (args: { society: number | { id: number }, billCycle: number | { id: number } } | [society: number | { id: number }, billCycle: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: generate.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::generate
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:120
* @route '/societies/{society}/bill-cycles/{billCycle}/generate'
*/
const generateForm = (args: { society: number | { id: number }, billCycle: number | { id: number } } | [society: number | { id: number }, billCycle: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: generate.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::generate
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:120
* @route '/societies/{society}/bill-cycles/{billCycle}/generate'
*/
generateForm.post = (args: { society: number | { id: number }, billCycle: number | { id: number } } | [society: number | { id: number }, billCycle: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: generate.url(args, options),
    method: 'post',
})

generate.form = generateForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::post
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:302
* @route '/societies/{society}/bill-cycles/{billCycle}/post'
*/
export const post = (args: { society: number | { id: number }, billCycle: number | { id: number } } | [society: number | { id: number }, billCycle: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: post.url(args, options),
    method: 'post',
})

post.definition = {
    methods: ["post"],
    url: '/societies/{society}/bill-cycles/{billCycle}/post',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::post
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:302
* @route '/societies/{society}/bill-cycles/{billCycle}/post'
*/
post.url = (args: { society: number | { id: number }, billCycle: number | { id: number } } | [society: number | { id: number }, billCycle: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            billCycle: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        billCycle: typeof args.billCycle === 'object'
        ? args.billCycle.id
        : args.billCycle,
    }

    return post.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{billCycle}', parsedArgs.billCycle.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::post
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:302
* @route '/societies/{society}/bill-cycles/{billCycle}/post'
*/
post.post = (args: { society: number | { id: number }, billCycle: number | { id: number } } | [society: number | { id: number }, billCycle: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: post.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::post
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:302
* @route '/societies/{society}/bill-cycles/{billCycle}/post'
*/
const postForm = (args: { society: number | { id: number }, billCycle: number | { id: number } } | [society: number | { id: number }, billCycle: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: post.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillCycleController::post
* @see app/Http/Controllers/SocietyAdmin/BillCycleController.php:302
* @route '/societies/{society}/bill-cycles/{billCycle}/post'
*/
postForm.post = (args: { society: number | { id: number }, billCycle: number | { id: number } } | [society: number | { id: number }, billCycle: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: post.url(args, options),
    method: 'post',
})

post.form = postForm

const billCycles = {
    index: Object.assign(index, index),
    create: Object.assign(create, create),
    store: Object.assign(store, store),
    generate: Object.assign(generate, generate),
    post: Object.assign(post, post),
}

export default billCycles