import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\OnboardingController::store
* @see app/Http/Controllers/OnboardingController.php:26
* @route '/onboarding/society'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/onboarding/society',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\OnboardingController::store
* @see app/Http/Controllers/OnboardingController.php:26
* @route '/onboarding/society'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\OnboardingController::store
* @see app/Http/Controllers/OnboardingController.php:26
* @route '/onboarding/society'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\OnboardingController::store
* @see app/Http/Controllers/OnboardingController.php:26
* @route '/onboarding/society'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\OnboardingController::store
* @see app/Http/Controllers/OnboardingController.php:26
* @route '/onboarding/society'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

const society = {
    store: Object.assign(store, store),
}

export default society