import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\OnboardingController::createOrder
* @see app/Http/Controllers/OnboardingController.php:184
* @route '/onboarding/payment/create-order'
*/
export const createOrder = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: createOrder.url(options),
    method: 'post',
})

createOrder.definition = {
    methods: ["post"],
    url: '/onboarding/payment/create-order',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\OnboardingController::createOrder
* @see app/Http/Controllers/OnboardingController.php:184
* @route '/onboarding/payment/create-order'
*/
createOrder.url = (options?: RouteQueryOptions) => {
    return createOrder.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\OnboardingController::createOrder
* @see app/Http/Controllers/OnboardingController.php:184
* @route '/onboarding/payment/create-order'
*/
createOrder.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: createOrder.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\OnboardingController::createOrder
* @see app/Http/Controllers/OnboardingController.php:184
* @route '/onboarding/payment/create-order'
*/
const createOrderForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: createOrder.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\OnboardingController::createOrder
* @see app/Http/Controllers/OnboardingController.php:184
* @route '/onboarding/payment/create-order'
*/
createOrderForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: createOrder.url(options),
    method: 'post',
})

createOrder.form = createOrderForm

const payment = {
    createOrder: Object.assign(createOrder, createOrder),
}

export default payment