import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../wayfinder'
/**
* @see \App\Http\Controllers\InstallController::index
* @see app/Http/Controllers/InstallController.php:55
* @route '/install'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/install',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\InstallController::index
* @see app/Http/Controllers/InstallController.php:55
* @route '/install'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\InstallController::index
* @see app/Http/Controllers/InstallController.php:55
* @route '/install'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::index
* @see app/Http/Controllers/InstallController.php:55
* @route '/install'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\InstallController::index
* @see app/Http/Controllers/InstallController.php:55
* @route '/install'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::index
* @see app/Http/Controllers/InstallController.php:55
* @route '/install'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::index
* @see app/Http/Controllers/InstallController.php:55
* @route '/install'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\InstallController::welcome
* @see app/Http/Controllers/InstallController.php:76
* @route '/install/welcome'
*/
export const welcome = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: welcome.url(options),
    method: 'get',
})

welcome.definition = {
    methods: ["get","head"],
    url: '/install/welcome',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\InstallController::welcome
* @see app/Http/Controllers/InstallController.php:76
* @route '/install/welcome'
*/
welcome.url = (options?: RouteQueryOptions) => {
    return welcome.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\InstallController::welcome
* @see app/Http/Controllers/InstallController.php:76
* @route '/install/welcome'
*/
welcome.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: welcome.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::welcome
* @see app/Http/Controllers/InstallController.php:76
* @route '/install/welcome'
*/
welcome.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: welcome.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\InstallController::welcome
* @see app/Http/Controllers/InstallController.php:76
* @route '/install/welcome'
*/
const welcomeForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: welcome.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::welcome
* @see app/Http/Controllers/InstallController.php:76
* @route '/install/welcome'
*/
welcomeForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: welcome.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::welcome
* @see app/Http/Controllers/InstallController.php:76
* @route '/install/welcome'
*/
welcomeForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: welcome.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

welcome.form = welcomeForm

/**
* @see \App\Http\Controllers\InstallController::requirements
* @see app/Http/Controllers/InstallController.php:90
* @route '/install/requirements'
*/
export const requirements = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: requirements.url(options),
    method: 'get',
})

requirements.definition = {
    methods: ["get","head"],
    url: '/install/requirements',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\InstallController::requirements
* @see app/Http/Controllers/InstallController.php:90
* @route '/install/requirements'
*/
requirements.url = (options?: RouteQueryOptions) => {
    return requirements.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\InstallController::requirements
* @see app/Http/Controllers/InstallController.php:90
* @route '/install/requirements'
*/
requirements.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: requirements.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::requirements
* @see app/Http/Controllers/InstallController.php:90
* @route '/install/requirements'
*/
requirements.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: requirements.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\InstallController::requirements
* @see app/Http/Controllers/InstallController.php:90
* @route '/install/requirements'
*/
const requirementsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: requirements.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::requirements
* @see app/Http/Controllers/InstallController.php:90
* @route '/install/requirements'
*/
requirementsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: requirements.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::requirements
* @see app/Http/Controllers/InstallController.php:90
* @route '/install/requirements'
*/
requirementsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: requirements.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

requirements.form = requirementsForm

/**
* @see \App\Http\Controllers\InstallController::database
* @see app/Http/Controllers/InstallController.php:124
* @route '/install/database'
*/
export const database = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: database.url(options),
    method: 'get',
})

database.definition = {
    methods: ["get","head"],
    url: '/install/database',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\InstallController::database
* @see app/Http/Controllers/InstallController.php:124
* @route '/install/database'
*/
database.url = (options?: RouteQueryOptions) => {
    return database.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\InstallController::database
* @see app/Http/Controllers/InstallController.php:124
* @route '/install/database'
*/
database.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: database.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::database
* @see app/Http/Controllers/InstallController.php:124
* @route '/install/database'
*/
database.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: database.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\InstallController::database
* @see app/Http/Controllers/InstallController.php:124
* @route '/install/database'
*/
const databaseForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: database.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::database
* @see app/Http/Controllers/InstallController.php:124
* @route '/install/database'
*/
databaseForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: database.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::database
* @see app/Http/Controllers/InstallController.php:124
* @route '/install/database'
*/
databaseForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: database.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

database.form = databaseForm

/**
* @see \App\Http\Controllers\InstallController::admin
* @see app/Http/Controllers/InstallController.php:235
* @route '/install/admin'
*/
export const admin = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: admin.url(options),
    method: 'get',
})

admin.definition = {
    methods: ["get","head"],
    url: '/install/admin',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\InstallController::admin
* @see app/Http/Controllers/InstallController.php:235
* @route '/install/admin'
*/
admin.url = (options?: RouteQueryOptions) => {
    return admin.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\InstallController::admin
* @see app/Http/Controllers/InstallController.php:235
* @route '/install/admin'
*/
admin.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: admin.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::admin
* @see app/Http/Controllers/InstallController.php:235
* @route '/install/admin'
*/
admin.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: admin.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\InstallController::admin
* @see app/Http/Controllers/InstallController.php:235
* @route '/install/admin'
*/
const adminForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: admin.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::admin
* @see app/Http/Controllers/InstallController.php:235
* @route '/install/admin'
*/
adminForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: admin.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::admin
* @see app/Http/Controllers/InstallController.php:235
* @route '/install/admin'
*/
adminForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: admin.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

admin.form = adminForm

/**
* @see \App\Http\Controllers\InstallController::finish
* @see app/Http/Controllers/InstallController.php:289
* @route '/install/finish'
*/
export const finish = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: finish.url(options),
    method: 'get',
})

finish.definition = {
    methods: ["get","head"],
    url: '/install/finish',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\InstallController::finish
* @see app/Http/Controllers/InstallController.php:289
* @route '/install/finish'
*/
finish.url = (options?: RouteQueryOptions) => {
    return finish.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\InstallController::finish
* @see app/Http/Controllers/InstallController.php:289
* @route '/install/finish'
*/
finish.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: finish.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::finish
* @see app/Http/Controllers/InstallController.php:289
* @route '/install/finish'
*/
finish.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: finish.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\InstallController::finish
* @see app/Http/Controllers/InstallController.php:289
* @route '/install/finish'
*/
const finishForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: finish.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::finish
* @see app/Http/Controllers/InstallController.php:289
* @route '/install/finish'
*/
finishForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: finish.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\InstallController::finish
* @see app/Http/Controllers/InstallController.php:289
* @route '/install/finish'
*/
finishForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: finish.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

finish.form = finishForm

/**
* @see \App\Http\Controllers\InstallController::complete
* @see app/Http/Controllers/InstallController.php:311
* @route '/install/complete'
*/
export const complete = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: complete.url(options),
    method: 'post',
})

complete.definition = {
    methods: ["post"],
    url: '/install/complete',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\InstallController::complete
* @see app/Http/Controllers/InstallController.php:311
* @route '/install/complete'
*/
complete.url = (options?: RouteQueryOptions) => {
    return complete.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\InstallController::complete
* @see app/Http/Controllers/InstallController.php:311
* @route '/install/complete'
*/
complete.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: complete.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\InstallController::complete
* @see app/Http/Controllers/InstallController.php:311
* @route '/install/complete'
*/
const completeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: complete.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\InstallController::complete
* @see app/Http/Controllers/InstallController.php:311
* @route '/install/complete'
*/
completeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: complete.url(options),
    method: 'post',
})

complete.form = completeForm

const install = {
    index: Object.assign(index, index),
    welcome: Object.assign(welcome, welcome),
    requirements: Object.assign(requirements, requirements),
    database: Object.assign(database, database),
    admin: Object.assign(admin, admin),
    finish: Object.assign(finish, finish),
    complete: Object.assign(complete, complete),
}

export default install