import SuperAdminLayout from '@/layouts/super-admin-layout';
import { Head, Link, router } from '@inertiajs/react';
import { Button } from '@/components/ui/button';
import { Plus, Edit2, Trash2, Star, User } from 'lucide-react';

export default function Index({ testimonials }: { testimonials: any[] }) {
    const handleDelete = (id: number) => {
        if (confirm('Are you sure?')) {
            router.delete(`/super-admin/cms/testimonials/${id}`);
        }
    };

    return (
        <SuperAdminLayout>
            <Head title="Manage Testimonials" />

            <div className="flex h-full flex-1 flex-col gap-8 p-8">
                <div className="flex items-center justify-between">
                    <div>
                        <h1 className="text-3xl font-bold bg-gradient-to-r from-pink-600 via-rose-600 to-red-600 dark:from-pink-400 dark:via-rose-400 dark:to-red-400 bg-clip-text text-transparent">
                            Testimonials Overlay
                        </h1>
                        <p className="text-muted-foreground">
                            Manage client reviews and testimonials.
                        </p>
                    </div>
                    <Link href="/super-admin/cms/testimonials/create">
                        <Button className="bg-gradient-to-r from-pink-600 to-rose-600 hover:from-pink-700 hover:to-rose-700 shadow-lg shadow-pink-500/25">
                            <Plus className="mr-2 h-4 w-4" />
                            Add Testimonial
                        </Button>
                    </Link>
                </div>

                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    {testimonials.map((testimonial) => (
                        <div key={testimonial.id} className="group relative bg-white/60 dark:bg-slate-900/60 backdrop-blur-xl p-6 rounded-2xl border border-slate-200/50 dark:border-slate-800/50 shadow-sm hover:shadow-xl transition-all">
                            <div className="flex justify-between items-start mb-4">
                                <div className="flex items-center gap-2">
                                    {[...Array(testimonial.rating || 5)].map((_, i) => (
                                        <Star key={i} className="h-4 w-4 fill-amber-400 text-amber-400" />
                                    ))}
                                </div>
                                <div className="flex gap-2 opacity-0 group-hover:opacity-100 transition-opacity">
                                    <Link href={`/super-admin/cms/testimonials/${testimonial.id}/edit`}>
                                        <Button size="icon" variant="ghost" className="h-8 w-8 hover:bg-pink-100 dark:hover:bg-pink-900/50">
                                            <Edit2 className="h-4 w-4 text-pink-600" />
                                        </Button>
                                    </Link>
                                    <Button size="icon" variant="ghost" className="h-8 w-8 hover:bg-red-100 dark:hover:bg-red-900/50" onClick={() => handleDelete(testimonial.id)}>
                                        <Trash2 className="h-4 w-4 text-red-600" />
                                    </Button>
                                </div>
                            </div>

                            <p className="text-slate-700 dark:text-slate-300 italic mb-4">"{testimonial.quote}"</p>
                            
                            <div className="flex items-center gap-3 mt-auto">
                                <div className="h-10 w-10 rounded-full bg-slate-200 dark:bg-slate-700 flex items-center justify-center">
                                    {testimonial.image ? (
                                        <img src={testimonial.image} alt={testimonial.author} className="h-full w-full rounded-full object-cover" />
                                    ) : (
                                        <User className="h-5 w-5 text-slate-500" />
                                    )}
                                </div>
                                <div>
                                    <p className="font-bold text-slate-900 dark:text-white text-sm">{testimonial.author}</p>
                                    <p className="text-xs text-slate-500 dark:text-slate-400">{testimonial.role}</p>
                                </div>
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        </SuperAdminLayout>
    );
}
