import SuperAdminLayout from '@/layouts/super-admin-layout';
import { Head, Link, router } from '@inertiajs/react';
import { Button } from '@/components/ui/button';
import { Plus, Edit2, Trash2 } from 'lucide-react';

export default function Index({ faqs }: { faqs: any[] }) {
    const handleDelete = (id: number) => {
        if (confirm('Are you sure?')) {
            router.delete(`/super-admin/cms/faqs/${id}`);
        }
    };

    return (
        <SuperAdminLayout>
            <Head title="Manage FAQs" />

            <div className="flex h-full flex-1 flex-col gap-8 p-8">
                <div className="flex items-center justify-between">
                    <div>
                        <h1 className="text-3xl font-bold bg-gradient-to-r from-blue-600 via-indigo-600 to-violet-600 dark:from-blue-400 dark:via-indigo-400 dark:to-violet-400 bg-clip-text text-transparent">
                            FAQs Overlay
                        </h1>
                        <p className="text-muted-foreground">
                            Manage frequently asked questions.
                        </p>
                    </div>
                    <Link href="/super-admin/cms/faqs/create">
                        <Button className="bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 shadow-lg shadow-blue-500/25">
                            <Plus className="mr-2 h-4 w-4" />
                            Add FAQ
                        </Button>
                    </Link>
                </div>

                <div className="grid gap-4">
                    {faqs.map((faq) => (
                        <div key={faq.id} className="group flex items-start justify-between bg-white/60 dark:bg-slate-900/60 backdrop-blur-xl p-6 rounded-2xl border border-slate-200/50 dark:border-slate-800/50 shadow-sm hover:shadow-md transition-all">
                            <div className="space-y-1">
                                <h3 className="text-lg font-bold text-slate-800 dark:text-slate-100">{faq.question}</h3>
                                <p className="text-slate-600 dark:text-slate-400 text-sm">{faq.answer}</p>
                            </div>
                            <div className="flex gap-2 opacity-0 group-hover:opacity-100 transition-opacity">
                                <Link href={`/super-admin/cms/faqs/${faq.id}/edit`}>
                                    <Button size="icon" variant="ghost" className="h-8 w-8 hover:bg-blue-100 dark:hover:bg-blue-900/50">
                                        <Edit2 className="h-4 w-4 text-blue-600" />
                                    </Button>
                                </Link>
                                <Button size="icon" variant="ghost" className="h-8 w-8 hover:bg-red-100 dark:hover:bg-red-900/50" onClick={() => handleDelete(faq.id)}>
                                    <Trash2 className="h-4 w-4 text-red-600" />
                                </Button>
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        </SuperAdminLayout>
    );
}
