import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import InputError from '@/components/input-error';

interface SocietyDetailsFormProps {
    data: any;
    setData: (key: string, value: any) => void;
    errors: any;
}

export default function SocietyDetailsForm({ data, setData, errors }: SocietyDetailsFormProps) {
    return (
        <div className="space-y-6">
            <div className="text-center mb-8">
                <h2 className="text-2xl font-bold text-gray-900 dark:text-white">Tell us about your Society</h2>
                <p className="text-gray-500 dark:text-gray-400">Enter the basic details to get started.</p>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div className="space-y-2">
                    <Label htmlFor="name">Society Name</Label>
                    <Input
                        id="name"
                        value={data.name}
                        onChange={(e) => setData('name', e.target.value)}
                        placeholder="e.g. Green Valley Heights"
                        required
                    />
                    <InputError message={errors.name} />
                </div>

                <div className="space-y-2">
                    <Label htmlFor="email">Official Email</Label>
                    <Input
                        id="email"
                        type="email"
                        value={data.email}
                        onChange={(e) => setData('email', e.target.value)}
                        placeholder="admin@greenvalley.com"
                        required
                    />
                    <InputError message={errors.email} />
                </div>

                <div className="space-y-2">
                    <Label htmlFor="phone">Contact Phone</Label>
                    <Input
                        id="phone"
                        value={data.phone}
                        onChange={(e) => setData('phone', e.target.value)}
                        placeholder="+91 98765 43210"
                        required
                    />
                    <InputError message={errors.phone} />
                </div>

                <div className="space-y-2">
                    <Label htmlFor="address">Address</Label>
                    <Input
                        id="address"
                        value={data.address}
                        onChange={(e) => setData('address', e.target.value)}
                        placeholder="123 Main St"
                        required
                    />
                    <InputError message={errors.address} />
                </div>

                <div className="space-y-2">
                    <Label htmlFor="city">City</Label>
                    <Input
                        id="city"
                        value={data.city}
                        onChange={(e) => setData('city', e.target.value)}
                        placeholder="Mumbai"
                        required
                    />
                    <InputError message={errors.city} />
                </div>

                <div className="space-y-2">
                    <Label htmlFor="state">State</Label>
                    <Input
                        id="state"
                        value={data.state}
                        onChange={(e) => setData('state', e.target.value)}
                        placeholder="Maharashtra"
                        required
                    />
                    <InputError message={errors.state} />
                </div>

                <div className="space-y-2">
                    <Label htmlFor="pincode">Pincode</Label>
                    <Input
                        id="pincode"
                        value={data.pincode}
                        onChange={(e) => setData('pincode', e.target.value)}
                        placeholder="400001"
                        required
                    />
                    <InputError message={errors.pincode} />
                </div>

                <div className="space-y-2">
                    <Label htmlFor="country">Country</Label>
                    <Input
                        id="country"
                        value={data.country}
                        onChange={(e) => setData('country', e.target.value)}
                        placeholder="India"
                        required
                    />
                    <InputError message={errors.country} />
                </div>
            </div>
        </div>
    );
}
