import { CreditCard, ShieldCheck, CheckCircle2 } from 'lucide-react';
import { Label } from '@/components/ui/label';
import { Input } from '@/components/ui/input';

interface PaymentPlaceholderProps {
    data: any;
    setData: (key: string, value: any) => void;
    settings: any;
}

export default function PaymentPlaceholder({ data, setData, settings }: PaymentPlaceholderProps) {
    const gateways = [
        { id: 'stripe', name: 'Stripe', enabled: settings?.stripe_enabled === '1' },
        { id: 'razorpay', name: 'Razorpay', enabled: settings?.razorpay_enabled === '1' },
        { id: 'paypal', name: 'PayPal', enabled: settings?.paypal_enabled === '1' },
    ].filter(g => g.enabled);

    return (
        <div className="space-y-8">
            <div className="text-center">
                <h2 className="text-2xl font-bold text-gray-900 dark:text-white">Select Payment Method</h2>
                <p className="text-gray-500 dark:text-gray-400">Choose your preferred payment gateway.</p>
            </div>

            {gateways.length > 0 ? (
                <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
                    {gateways.map((gateway) => (
                        <div
                            key={gateway.id}
                            onClick={() => setData('payment_method', gateway.id)}
                            className={`cursor-pointer rounded-xl border-2 p-6 flex flex-col items-center justify-center gap-4 transition-all duration-200 ${
                                data.payment_method === gateway.id
                                    ? 'border-blue-600 bg-blue-50 dark:bg-blue-900/20 dark:border-blue-500'
                                    : 'border-gray-200 dark:border-gray-700 hover:border-blue-300 dark:hover:border-blue-700 hover:bg-gray-50 dark:hover:bg-gray-800'
                            }`}
                        >
                            <div className={`w-12 h-12 rounded-full flex items-center justify-center ${
                                data.payment_method === gateway.id 
                                    ? 'bg-blue-600 text-white' 
                                    : 'bg-gray-100 dark:bg-gray-700 text-gray-500'
                            }`}>
                                {data.payment_method === gateway.id ? (
                                    <CheckCircle2 className="w-6 h-6" />
                                ) : (
                                    <CreditCard className="w-6 h-6" />
                                )}
                            </div>
                            <span className="font-semibold text-lg">{gateway.name}</span>
                        </div>
                    ))}
                </div>
            ) : (
                <div className="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-xl p-6 flex items-start gap-4">
                    <ShieldCheck className="w-6 h-6 text-yellow-600 dark:text-yellow-400 flex-shrink-0 mt-1" />
                    <div>
                        <h3 className="font-semibold text-yellow-900 dark:text-yellow-300">No Payment Gateways Enabled</h3>
                        <p className="text-sm text-yellow-700 dark:text-yellow-400 mt-1">
                            Please contact the administrator to enable payment gateways in the system settings.
                        </p>
                    </div>
                </div>
            )}

            <div className="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-xl p-6 flex items-start gap-4">
                <ShieldCheck className="w-6 h-6 text-blue-600 dark:text-blue-400 flex-shrink-0 mt-1" />
                <div>
                    <h3 className="font-semibold text-blue-900 dark:text-blue-300">Secure Transaction</h3>
                    <p className="text-sm text-blue-700 dark:text-blue-400 mt-1">
                        This is a secure 128-bit SSL encrypted payment. Your card details are safe.
                    </p>
                </div>
            </div>
        </div>
    );
}
