import { CheckCircle2, AlertTriangle } from 'lucide-react';

interface ActivationStepProps {
    onSubmit: () => void;
    processing: boolean;
    paymentCompleted: boolean;
}

export default function ActivationStep({ onSubmit, processing, paymentCompleted }: ActivationStepProps) {
    if (!paymentCompleted) {
        return (
            <div className="text-center space-y-6 py-8">
                <div className="w-20 h-20 bg-yellow-100 dark:bg-yellow-900/30 rounded-full flex items-center justify-center mx-auto mb-6">
                    <AlertTriangle className="w-10 h-10 text-yellow-600 dark:text-yellow-400" />
                </div>

                <h2 className="text-3xl font-bold text-gray-900 dark:text-white">Payment Required</h2>
                
                <p className="text-lg text-gray-600 dark:text-gray-300 max-w-lg mx-auto">
                    Please go back and complete the payment step before activating your society.
                </p>
            </div>
        );
    }

    return (
        <div className="text-center space-y-6 py-8">
            <div className="w-20 h-20 bg-green-100 dark:bg-green-900/30 rounded-full flex items-center justify-center mx-auto mb-6">
                <CheckCircle2 className="w-10 h-10 text-green-600 dark:text-green-400" />
            </div>

            <h2 className="text-3xl font-bold text-gray-900 dark:text-white">Ready to Activate!</h2>
            
            <p className="text-lg text-gray-600 dark:text-gray-300 max-w-lg mx-auto">
                Your payment was successful! Click the button below to create your society and start using the platform.
            </p>

            <div className="bg-gray-50 dark:bg-gray-800 rounded-xl p-6 max-w-md mx-auto text-left space-y-2 text-sm text-gray-500 dark:text-gray-400">
                <p>By clicking "Complete Setup", you agree to our Terms of Service and Privacy Policy.</p>
                <p>Your subscription is now active and will begin immediately.</p>
            </div>
        </div>
    );
}
