import InputError from '@/components/input-error';
import { Button } from '@/components/ui/button';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { Textarea } from '@/components/ui/textarea';
import SocietyAdminLayout from '@/layouts/society-admin-layout';
import { type BreadcrumbItem } from '@/types';
import { Form, Head, Link } from '@inertiajs/react';
import { ArrowLeft } from 'lucide-react';

const breadcrumbs: BreadcrumbItem[] = [
    { title: 'Vendors', href: '/societies/{society}/vendors' },
    { title: 'Create', href: '#' },
];

interface CreateProps {
    society: {
        id: number;
        name: string;
        code?: string;
    };
    errors?: Record<string, string>;
}

export default function Create({ society, errors }: CreateProps) {
    return (
        <SocietyAdminLayout breadcrumbs={breadcrumbs} society={society}>
            <Head title="Create Vendor" />
            <div className="flex h-full flex-1 flex-col gap-6 overflow-x-auto rounded-xl p-6">
                <div className="flex items-center gap-4">
                    <Link href={`/societies/${society.id}/vendors`}>
                        <Button variant="ghost" size="sm">
                            <ArrowLeft className="mr-2 h-4 w-4" />
                            Back
                        </Button>
                    </Link>
                    <div>
                        <h1 className="text-2xl font-bold">Create Vendor</h1>
                        <p className="text-muted-foreground">Add a new service provider/vendor</p>
                    </div>
                </div>

                <Card>
                    <CardHeader>
                        <CardTitle>Vendor Information</CardTitle>
                    </CardHeader>
                    <CardContent>
                        <Form
                            method="post"
                            action={`/societies/${society.id}/vendors`}
                            className="grid gap-6 md:grid-cols-2"
                        >
                            <div className="space-y-2">
                                <Label htmlFor="name">Name</Label>
                                <Input id="name" name="name" autoComplete="off" />
                                <InputError message={errors?.name} />
                            </div>

                            <div className="space-y-2">
                                <Label htmlFor="company_name">Company Name</Label>
                                <Input id="company_name" name="company_name" autoComplete="off" />
                                <InputError message={errors?.company_name} />
                            </div>

                            <div className="space-y-2">
                                <Label htmlFor="phone">Phone</Label>
                                <Input id="phone" name="phone" autoComplete="off" />
                                <InputError message={errors?.phone} />
                            </div>

                            <div className="space-y-2">
                                <Label htmlFor="email">Email</Label>
                                <Input id="email" name="email" type="email" autoComplete="off" />
                                <InputError message={errors?.email} />
                            </div>

                            <div className="space-y-2">
                                <Label htmlFor="gst_number">GST Number</Label>
                                <Input id="gst_number" name="gst_number" autoComplete="off" />
                                <InputError message={errors?.gst_number} />
                            </div>

                            <div className="space-y-2">
                                <Label htmlFor="status">Status</Label>
                                <select
                                    id="status"
                                    name="status"
                                    defaultValue="active"
                                    className="mt-1 block w-full rounded-md border border-input bg-background px-3 py-2 text-sm shadow-sm focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring"
                                >
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                                <InputError message={errors?.status} />
                            </div>

                            <div className="md:col-span-2 space-y-2">
                                <Label htmlFor="address">Address</Label>
                                <Textarea id="address" name="address" rows={3} />
                                <InputError message={errors?.address} />
                            </div>

                            <div className="md:col-span-2 flex justify-end gap-3">
                                <Button type="submit">Save Vendor</Button>
                            </div>
                        </Form>
                    </CardContent>
                </Card>
            </div>
        </SocietyAdminLayout>
    );
}


