import { Skeleton } from '@/components/ui/skeleton';
import SocietyAdminLayout from '@/layouts/society-admin-layout';
import { Head } from '@inertiajs/react';

export default function DashboardSkeleton() {
    return (
        <SocietyAdminLayout breadcrumbs={[{ title: 'Dashboard', href: '#' }]} society={{ id: 0, name: 'Loading...', registration_no: '...' } as any}>
            <Head title="Dashboard" />
            <div className="flex flex-1 flex-col gap-8 p-6 md:p-8 overflow-x-hidden bg-muted/10">
                
                {/* Banner Skeleton */}
                <div className="relative overflow-hidden rounded-2xl bg-card p-8 border border-border/50">
                    <div className="flex flex-col md:flex-row justify-between items-start md:items-center gap-6">
                        <div className="space-y-4">
                            <Skeleton className="h-8 w-48" />
                            <Skeleton className="h-6 w-64" />
                        </div>
                        <Skeleton className="h-16 w-48 rounded-xl" />
                    </div>
                </div>

                {/* KPIs Skeleton */}
                <div>
                     <Skeleton className="h-7 w-48 mb-4" />
                     <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-4">
                        {[...Array(4)].map((_, i) => (
                            <div key={i} className="bg-card/50 p-6 rounded-xl border border-border/50 space-y-4">
                                <div className="flex justify-between">
                                    <Skeleton className="h-4 w-24" />
                                    <Skeleton className="h-10 w-10 rounded-xl" />
                                </div>
                                <Skeleton className="h-8 w-32" />
                            </div>
                        ))}
                     </div>
                </div>

                {/* Charts Skeleton */}
                <div className="grid gap-6 md:grid-cols-3">
                     <div className="md:col-span-2 bg-card/50 rounded-xl border border-border/50 p-6 space-y-6">
                        <div className="space-y-2">
                            <Skeleton className="h-6 w-32" />
                            <Skeleton className="h-4 w-48" />
                        </div>
                        <Skeleton className="h-[300px] w-full" />
                     </div>

                     <div className="bg-card/50 rounded-xl border border-border/50 p-6 space-y-6">
                         <div className="space-y-2">
                             <Skeleton className="h-6 w-32" />
                             <Skeleton className="h-4 w-24" />
                             <Skeleton className="h-[200px] w-full rounded-full" />
                         </div>
                     </div>
                </div>

                {/* Recent Activity Skeleton */}
                 <div className="bg-card/50 rounded-xl border border-border/50 p-6 space-y-6">
                    <div className="flex justify-between items-center">
                         <div className="space-y-2">
                            <Skeleton className="h-6 w-32" />
                            <Skeleton className="h-4 w-48" />
                         </div>
                         <Skeleton className="h-10 w-10 rounded-full" />
                    </div>
                    <Skeleton className="h-10 w-full max-w-sm rounded-lg" />
                    <div className="space-y-4">
                        {[...Array(3)].map((_, i) => (
                            <div key={i} className="flex justify-between items-center">
                                <div className="flex gap-4">
                                     <Skeleton className="h-10 w-10 rounded-full" />
                                     <div className="space-y-2">
                                        <Skeleton className="h-4 w-32" />
                                        <Skeleton className="h-3 w-24" />
                                     </div>
                                </div>
                                <Skeleton className="h-8 w-20 rounded-lg" />
                            </div>
                        ))}
                    </div>
                 </div>

            </div>
        </SocietyAdminLayout>
    );
}
