import PublicLayout from '@/layouts/public-layout';
import { Head } from '@inertiajs/react';

interface LegalProps {
    title: string;
    content: string;
    updated_at?: string;
}

export default function Legal({ title, content, updated_at }: LegalProps) {
    return (
        <PublicLayout>
            <Head title={title} />

            <div className="py-24 bg-background min-h-screen">
                <div className="container mx-auto px-4 max-w-4xl">
                    <div className="mb-12 text-center">
                        <h1 className="text-4xl md:text-5xl font-bold mb-4 bg-gradient-to-r from-foreground to-foreground/70 bg-clip-text text-transparent">
                            {title}
                        </h1>
                        {updated_at && (
                            <p className="text-muted-foreground">
                                Last updated: {new Date(updated_at).toLocaleDateString()}
                            </p>
                        )}
                    </div>

                    <div 
                        className="prose prose-lg dark:prose-invert max-w-none bg-card/50 backdrop-blur-sm p-8 md:p-12 rounded-2xl border border-border/50 shadow-xl"
                        dangerouslySetInnerHTML={{ __html: content }}
                    />
                </div>
            </div>
        </PublicLayout>
    );
}
