import AppLogoIcon from '@/components/app-logo-icon';
import { home } from '@/routes';
import { type SharedData } from '@/types';
import { Link, usePage } from '@inertiajs/react';
import { motion } from 'framer-motion';
import { type PropsWithChildren } from 'react';

interface AuthLayoutProps {
    title?: string;
    description?: string;
}

export default function AuthSplitLayout({
    children,
    title,
    description,
}: PropsWithChildren<AuthLayoutProps>) {
    const { name, quote } = usePage<SharedData>().props;

    return (
        <div className="relative grid min-h-screen flex-col items-center justify-center lg:max-w-none lg:grid-cols-2 lg:px-0">
            <div className="relative hidden h-full flex-col bg-zinc-900 p-10 text-white dark:border-r lg:flex">
                {/* Premium Background Gradient/Mesh */}
                <div className="absolute inset-0 overflow-hidden bg-neutral-900">
                    <div className="absolute inset-0 bg-linear-to-tr from-sky-900/90 via-sky-900/90 to-neutral-900/90 mix-blend-multiply transition-colors md:via-neutral-900/40" />
                    <motion.div
                        initial={{ opacity: 0, scale: 1.1 }}
                        animate={{ opacity: 0.4, scale: 1 }}
                        transition={{ duration: 1.5, ease: 'easeOut' }}
                        className="absolute -top-[20%] -left-[20%] h-[70%] w-[70%] rounded-full bg-cyan-700 blur-[120px]"
                    />
                    <motion.div
                        initial={{ opacity: 0, scale: 1.1 }}
                        animate={{ opacity: 0.3, scale: 1 }}
                        transition={{ duration: 2, ease: 'easeOut', delay: 0.5 }}
                        className="absolute -bottom-[20%] -right-[20%] h-[70%] w-[70%] rounded-full bg-teal-800 blur-[120px]"
                    />
                </div>

                <Link
                    href={home()}
                    className="relative z-20 flex items-center text-lg font-medium tracking-tight"
                >
                    <motion.div
                        initial={{ x: -20, opacity: 0 }}
                        animate={{ x: 0, opacity: 1 }}
                        transition={{ delay: 0.2 }}
                        className="flex items-center gap-2"
                    >
                        <AppLogoIcon className="size-8 fill-current text-cyan-100" />
                        <span className="font-heading font-bold text-white">{name}</span>
                    </motion.div>
                </Link>

                <div className="relative z-20 mt-auto">
                    <motion.div
                        initial={{ y: 20, opacity: 0 }}
                        animate={{ y: 0, opacity: 1 }}
                        transition={{ delay: 0.4, duration: 0.6 }}
                    >
                        <blockquote className="space-y-4 border-l-2 border-cyan-400 pl-6">
                            <p className="font-heading text-2xl font-medium leading-relaxed tracking-tight text-white lg:text-3xl">
                                &ldquo;{quote?.message ?? "Manage your society with elegance and efficiency."}&rdquo;
                            </p>
                            <footer className="text-base font-medium text-cyan-200">
                                {quote?.author ?? "Societify Team"}
                            </footer>
                        </blockquote>
                    </motion.div>
                </div>
            </div>

            <div className="flex w-full items-center justify-center p-8 lg:p-8">
                <motion.div
                    initial={{ opacity: 0, y: 10 }}
                    animate={{ opacity: 1, y: 0 }}
                    transition={{ delay: 0.2, duration: 0.5 }}
                    className="mx-auto flex w-full flex-col justify-center space-y-6 sm:w-[400px]"
                >
                    <div className="flex flex-col items-center gap-2 text-center">
                        <Link
                             href={home()}
                             className="mb-8 flex items-center gap-2 lg:hidden"
                        >
                             <AppLogoIcon className="size-10 fill-current text-primary" />
                        </Link>
                        
                        <h1 className="font-heading text-3xl font-bold tracking-tight text-foreground">
                            {title}
                        </h1>
                        <p className="text-base text-muted-foreground">
                            {description}
                        </p>
                    </div>
                    {children}
                </motion.div>
            </div>
        </div>
    );
}
