import AuthLayoutTemplate from '@/layouts/auth/auth-split-layout';
import FlashMessagesProvider from '@/components/flash-messages-provider';

export default function AuthLayout({
    children,
    title,
    description,
    ...props
}: {
    children: React.ReactNode;
    title: string;
    description: string;
}) {
    return (
        <FlashMessagesProvider>
            <AuthLayoutTemplate title={title} description={description} {...props}>
                {children}
            </AuthLayoutTemplate>
        </FlashMessagesProvider>
    );
}
