import AppLayoutTemplate from '@/layouts/app/app-sidebar-layout';
import FlashMessagesProvider from '@/components/flash-messages-provider';
import { type BreadcrumbItem } from '@/types';
import { type ReactNode } from 'react';

interface AppLayoutProps {
    children: ReactNode;
    breadcrumbs?: BreadcrumbItem[];
}

export default ({ children, breadcrumbs, ...props }: AppLayoutProps) => (
    <FlashMessagesProvider>
        <AppLayoutTemplate breadcrumbs={breadcrumbs} {...props}>
            {children}
        </AppLayoutTemplate>
    </FlashMessagesProvider>
);
