import { BreadcrumbItem } from "@/types";
import { Link } from "@inertiajs/react";
import { ChevronRight, Home } from "lucide-react";
import { cn } from "@/lib/utils";

interface PageHeaderProps {
    title: string;
    description?: string;
    breadcrumbs?: BreadcrumbItem[];
    actions?: React.ReactNode;
    className?: string;
}

export function PageHeader({ 
    title, 
    description, 
    breadcrumbs = [], 
    actions,
    className 
}: PageHeaderProps) {
    return (
        <div className={cn("flex flex-col gap-4 md:flex-row md:items-center md:justify-between", className)}>
            <div className="space-y-1.5">
                {breadcrumbs.length > 0 && (
                    <nav className="flex items-center gap-1 text-sm text-muted-foreground mb-2">
                        <Link 
                            href="/super-admin/dashboard" 
                            className="flex items-center hover:text-primary transition-colors"
                        >
                            <Home className="h-4 w-4" />
                        </Link>
                        {breadcrumbs.map((crumb, index) => (
                            <div key={index} className="flex items-center gap-1">
                                <ChevronRight className="h-4 w-4" />
                                <Link 
                                    href={crumb.href}
                                    className={cn(
                                        "hover:text-primary transition-colors",
                                        index === breadcrumbs.length - 1 && "font-medium text-foreground pointer-events-none"
                                    )}
                                >
                                    {crumb.title}
                                </Link>
                            </div>
                        ))}
                    </nav>
                )}
                <h1 className="text-2xl font-bold tracking-tight bg-gradient-to-r from-gray-900 to-gray-600 dark:from-gray-100 dark:to-gray-400 bg-clip-text text-transparent">
                    {title}
                </h1>
                {description && (
                    <p className="text-muted-foreground">
                        {description}
                    </p>
                )}
            </div>
            {actions && (
                <div className="flex items-center gap-2">
                    {actions}
                </div>
            )}
        </div>
    );
}
