import { cn } from "@/lib/utils"
import { Ref, forwardRef } from "react"

interface GlassCardProps extends React.HTMLAttributes<HTMLDivElement> {
    variant?: "default" | "hover" | "active"
    intensity?: "low" | "medium" | "high"
}

const GlassCard = forwardRef<HTMLDivElement, GlassCardProps>(
    ({ className, variant = "default", intensity = "medium", children, ...props }, ref) => {
        const intensityMap = {
            low: "bg-white/40 dark:bg-black/20 backdrop-blur-md border-white/20 dark:border-white/5",
            medium: "bg-white/60 dark:bg-black/40 backdrop-blur-lg border-white/30 dark:border-white/10",
            high: "bg-white/80 dark:bg-black/60 backdrop-blur-xl border-white/40 dark:border-white/15",
        }

        const variantMap = {
            default: "",
            hover: "hover:bg-white/70 dark:hover:bg-black/50 hover:shadow-lg transition-all duration-300",
            active: "active:scale-[0.98] transition-transform",
        }

        return (
            <div
                ref={ref}
                className={cn(
                    "rounded-2xl border shadow-sm",
                    intensityMap[intensity],
                    variantMap[variant],
                    className
                )}
                {...props}
            >
                {children}
            </div>
        )
    }
)
GlassCard.displayName = "GlassCard"

export { GlassCard }
