import AppLogoIcon from './app-logo-icon';
import { usePage } from '@inertiajs/react';

export default function AppLogo() {
    const { settings } = usePage().props as any;
    const appName = settings?.app_name || 'Societify';
    const appLogo = settings?.app_logo;

    return (
        <>
            <div className="flex aspect-square size-8 items-center justify-center rounded-md bg-sidebar-primary text-sidebar-primary-foreground overflow-hidden">
                {appLogo ? (
                    <img src={appLogo} alt={appName} className="size-6 object-contain" />
                ) : (
                    <AppLogoIcon className="size-5 fill-current text-white dark:text-black" />
                )}
            </div>
            {/* Only show name if no logo is set */}
            {!appLogo && (
                <div className="ml-1 grid flex-1 text-left text-sm">
                    <span className="mb-0.5 truncate leading-tight font-semibold">
                        {appName}
                    </span>
                </div>
            )}
        </>
    );
}
