import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\WebhookController::handleRazorpay
* @see app/Http/Controllers/WebhookController.php:22
* @route '/api/webhooks/razorpay'
*/
export const handleRazorpay = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: handleRazorpay.url(options),
    method: 'post',
})

handleRazorpay.definition = {
    methods: ["post"],
    url: '/api/webhooks/razorpay',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\WebhookController::handleRazorpay
* @see app/Http/Controllers/WebhookController.php:22
* @route '/api/webhooks/razorpay'
*/
handleRazorpay.url = (options?: RouteQueryOptions) => {
    return handleRazorpay.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\WebhookController::handleRazorpay
* @see app/Http/Controllers/WebhookController.php:22
* @route '/api/webhooks/razorpay'
*/
handleRazorpay.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: handleRazorpay.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\WebhookController::handleRazorpay
* @see app/Http/Controllers/WebhookController.php:22
* @route '/api/webhooks/razorpay'
*/
const handleRazorpayForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: handleRazorpay.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\WebhookController::handleRazorpay
* @see app/Http/Controllers/WebhookController.php:22
* @route '/api/webhooks/razorpay'
*/
handleRazorpayForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: handleRazorpay.url(options),
    method: 'post',
})

handleRazorpay.form = handleRazorpayForm

const WebhookController = { handleRazorpay }

export default WebhookController