import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::index
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:18
* @route '/super-admin/settings'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/super-admin/settings',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::index
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:18
* @route '/super-admin/settings'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::index
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:18
* @route '/super-admin/settings'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::index
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:18
* @route '/super-admin/settings'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::index
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:18
* @route '/super-admin/settings'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::index
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:18
* @route '/super-admin/settings'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::index
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:18
* @route '/super-admin/settings'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::update
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:30
* @route '/super-admin/settings'
*/
export const update = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: update.url(options),
    method: 'post',
})

update.definition = {
    methods: ["post"],
    url: '/super-admin/settings',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::update
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:30
* @route '/super-admin/settings'
*/
update.url = (options?: RouteQueryOptions) => {
    return update.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::update
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:30
* @route '/super-admin/settings'
*/
update.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: update.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::update
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:30
* @route '/super-admin/settings'
*/
const updateForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::update
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:30
* @route '/super-admin/settings'
*/
updateForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(options),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::upload
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:126
* @route '/super-admin/settings/upload'
*/
export const upload = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: upload.url(options),
    method: 'post',
})

upload.definition = {
    methods: ["post"],
    url: '/super-admin/settings/upload',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::upload
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:126
* @route '/super-admin/settings/upload'
*/
upload.url = (options?: RouteQueryOptions) => {
    return upload.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::upload
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:126
* @route '/super-admin/settings/upload'
*/
upload.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: upload.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::upload
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:126
* @route '/super-admin/settings/upload'
*/
const uploadForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: upload.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::upload
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:126
* @route '/super-admin/settings/upload'
*/
uploadForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: upload.url(options),
    method: 'post',
})

upload.form = uploadForm

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::uploadFirebaseCredentials
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:148
* @route '/super-admin/settings/firebase/upload'
*/
export const uploadFirebaseCredentials = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: uploadFirebaseCredentials.url(options),
    method: 'post',
})

uploadFirebaseCredentials.definition = {
    methods: ["post"],
    url: '/super-admin/settings/firebase/upload',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::uploadFirebaseCredentials
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:148
* @route '/super-admin/settings/firebase/upload'
*/
uploadFirebaseCredentials.url = (options?: RouteQueryOptions) => {
    return uploadFirebaseCredentials.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::uploadFirebaseCredentials
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:148
* @route '/super-admin/settings/firebase/upload'
*/
uploadFirebaseCredentials.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: uploadFirebaseCredentials.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::uploadFirebaseCredentials
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:148
* @route '/super-admin/settings/firebase/upload'
*/
const uploadFirebaseCredentialsForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: uploadFirebaseCredentials.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::uploadFirebaseCredentials
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:148
* @route '/super-admin/settings/firebase/upload'
*/
uploadFirebaseCredentialsForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: uploadFirebaseCredentials.url(options),
    method: 'post',
})

uploadFirebaseCredentials.form = uploadFirebaseCredentialsForm

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::removeFirebaseCredentials
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:211
* @route '/super-admin/settings/firebase/remove'
*/
export const removeFirebaseCredentials = (options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: removeFirebaseCredentials.url(options),
    method: 'delete',
})

removeFirebaseCredentials.definition = {
    methods: ["delete"],
    url: '/super-admin/settings/firebase/remove',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::removeFirebaseCredentials
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:211
* @route '/super-admin/settings/firebase/remove'
*/
removeFirebaseCredentials.url = (options?: RouteQueryOptions) => {
    return removeFirebaseCredentials.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::removeFirebaseCredentials
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:211
* @route '/super-admin/settings/firebase/remove'
*/
removeFirebaseCredentials.delete = (options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: removeFirebaseCredentials.url(options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::removeFirebaseCredentials
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:211
* @route '/super-admin/settings/firebase/remove'
*/
const removeFirebaseCredentialsForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: removeFirebaseCredentials.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\SystemSettingController::removeFirebaseCredentials
* @see app/Http/Controllers/SuperAdmin/SystemSettingController.php:211
* @route '/super-admin/settings/firebase/remove'
*/
removeFirebaseCredentialsForm.delete = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: removeFirebaseCredentials.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

removeFirebaseCredentials.form = removeFirebaseCredentialsForm

const SystemSettingController = { index, update, upload, uploadFirebaseCredentials, removeFirebaseCredentials }

export default SystemSettingController