import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::index
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:10
* @route '/super-admin/cms/faqs'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/super-admin/cms/faqs',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::index
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:10
* @route '/super-admin/cms/faqs'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::index
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:10
* @route '/super-admin/cms/faqs'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::index
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:10
* @route '/super-admin/cms/faqs'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::index
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:10
* @route '/super-admin/cms/faqs'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::index
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:10
* @route '/super-admin/cms/faqs'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::index
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:10
* @route '/super-admin/cms/faqs'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::create
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:17
* @route '/super-admin/cms/faqs/create'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/super-admin/cms/faqs/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::create
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:17
* @route '/super-admin/cms/faqs/create'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::create
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:17
* @route '/super-admin/cms/faqs/create'
*/
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::create
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:17
* @route '/super-admin/cms/faqs/create'
*/
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::create
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:17
* @route '/super-admin/cms/faqs/create'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::create
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:17
* @route '/super-admin/cms/faqs/create'
*/
createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::create
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:17
* @route '/super-admin/cms/faqs/create'
*/
createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::store
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:22
* @route '/super-admin/cms/faqs'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/super-admin/cms/faqs',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::store
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:22
* @route '/super-admin/cms/faqs'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::store
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:22
* @route '/super-admin/cms/faqs'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::store
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:22
* @route '/super-admin/cms/faqs'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::store
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:22
* @route '/super-admin/cms/faqs'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::show
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:0
* @route '/super-admin/cms/faqs/{faq}'
*/
export const show = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/super-admin/cms/faqs/{faq}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::show
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:0
* @route '/super-admin/cms/faqs/{faq}'
*/
show.url = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { faq: args }
    }

    if (Array.isArray(args)) {
        args = {
            faq: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        faq: args.faq,
    }

    return show.definition.url
            .replace('{faq}', parsedArgs.faq.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::show
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:0
* @route '/super-admin/cms/faqs/{faq}'
*/
show.get = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::show
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:0
* @route '/super-admin/cms/faqs/{faq}'
*/
show.head = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::show
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:0
* @route '/super-admin/cms/faqs/{faq}'
*/
const showForm = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::show
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:0
* @route '/super-admin/cms/faqs/{faq}'
*/
showForm.get = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::show
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:0
* @route '/super-admin/cms/faqs/{faq}'
*/
showForm.head = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::edit
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:37
* @route '/super-admin/cms/faqs/{faq}/edit'
*/
export const edit = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/super-admin/cms/faqs/{faq}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::edit
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:37
* @route '/super-admin/cms/faqs/{faq}/edit'
*/
edit.url = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { faq: args }
    }

    if (Array.isArray(args)) {
        args = {
            faq: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        faq: args.faq,
    }

    return edit.definition.url
            .replace('{faq}', parsedArgs.faq.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::edit
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:37
* @route '/super-admin/cms/faqs/{faq}/edit'
*/
edit.get = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::edit
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:37
* @route '/super-admin/cms/faqs/{faq}/edit'
*/
edit.head = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::edit
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:37
* @route '/super-admin/cms/faqs/{faq}/edit'
*/
const editForm = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::edit
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:37
* @route '/super-admin/cms/faqs/{faq}/edit'
*/
editForm.get = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::edit
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:37
* @route '/super-admin/cms/faqs/{faq}/edit'
*/
editForm.head = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::update
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:45
* @route '/super-admin/cms/faqs/{faq}'
*/
export const update = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/super-admin/cms/faqs/{faq}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::update
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:45
* @route '/super-admin/cms/faqs/{faq}'
*/
update.url = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { faq: args }
    }

    if (Array.isArray(args)) {
        args = {
            faq: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        faq: args.faq,
    }

    return update.definition.url
            .replace('{faq}', parsedArgs.faq.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::update
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:45
* @route '/super-admin/cms/faqs/{faq}'
*/
update.put = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::update
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:45
* @route '/super-admin/cms/faqs/{faq}'
*/
update.patch = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::update
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:45
* @route '/super-admin/cms/faqs/{faq}'
*/
const updateForm = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::update
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:45
* @route '/super-admin/cms/faqs/{faq}'
*/
updateForm.put = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::update
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:45
* @route '/super-admin/cms/faqs/{faq}'
*/
updateForm.patch = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::destroy
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:62
* @route '/super-admin/cms/faqs/{faq}'
*/
export const destroy = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/super-admin/cms/faqs/{faq}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::destroy
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:62
* @route '/super-admin/cms/faqs/{faq}'
*/
destroy.url = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { faq: args }
    }

    if (Array.isArray(args)) {
        args = {
            faq: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        faq: args.faq,
    }

    return destroy.definition.url
            .replace('{faq}', parsedArgs.faq.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::destroy
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:62
* @route '/super-admin/cms/faqs/{faq}'
*/
destroy.delete = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::destroy
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:62
* @route '/super-admin/cms/faqs/{faq}'
*/
const destroyForm = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\CmsFaqController::destroy
* @see app/Http/Controllers/SuperAdmin/CmsFaqController.php:62
* @route '/super-admin/cms/faqs/{faq}'
*/
destroyForm.delete = (args: { faq: string | number } | [faq: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const CmsFaqController = { index, create, store, show, edit, update, destroy }

export default CmsFaqController