import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../../wayfinder'
/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::create
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:18
* @route '/super-admin/login'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/super-admin/login',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::create
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:18
* @route '/super-admin/login'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::create
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:18
* @route '/super-admin/login'
*/
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::create
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:18
* @route '/super-admin/login'
*/
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::create
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:18
* @route '/super-admin/login'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::create
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:18
* @route '/super-admin/login'
*/
createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::create
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:18
* @route '/super-admin/login'
*/
createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::store
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:29
* @route '/super-admin/login'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/super-admin/login',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::store
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:29
* @route '/super-admin/login'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::store
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:29
* @route '/super-admin/login'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::store
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:29
* @route '/super-admin/login'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::store
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:29
* @route '/super-admin/login'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::destroy
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:50
* @route '/super-admin/logout'
*/
export const destroy = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: destroy.url(options),
    method: 'post',
})

destroy.definition = {
    methods: ["post"],
    url: '/super-admin/logout',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::destroy
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:50
* @route '/super-admin/logout'
*/
destroy.url = (options?: RouteQueryOptions) => {
    return destroy.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::destroy
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:50
* @route '/super-admin/logout'
*/
destroy.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: destroy.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::destroy
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:50
* @route '/super-admin/logout'
*/
const destroyForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SuperAdmin\Auth\AuthenticatedSessionController::destroy
* @see app/Http/Controllers/SuperAdmin/Auth/AuthenticatedSessionController.php:50
* @route '/super-admin/logout'
*/
destroyForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(options),
    method: 'post',
})

destroy.form = destroyForm

const AuthenticatedSessionController = { create, store, destroy }

export default AuthenticatedSessionController